/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jovsonz;

import java.io.IOException;
import jp.sourceforge.jovsonz.JsParseException;
import jp.sourceforge.jovsonz.JsTypes;
import jp.sourceforge.jovsonz.JsValue;
import jp.sourceforge.jovsonz.JsVisitException;
import jp.sourceforge.jovsonz.JsonSource;
import jp.sourceforge.jovsonz.ValueVisitor;

public final class JsNull
implements JsValue,
Comparable<JsNull> {
    public static final JsNull NULL = new JsNull();
    public static final String TEXT = "null";
    public static final int ONLYHASH = 982451653;

    private JsNull() {
    }

    static JsNull parseNull(JsonSource source) throws IOException, JsParseException {
        char charHead = source.readOrDie();
        if (charHead != 'n') {
            source.unread(charHead);
            return null;
        }
        if (!source.matchOrDie("ull")) {
            throw new JsParseException("invalid JSON token", source.getLineNumber());
        }
        return NULL;
    }

    @Override
    public JsTypes getJsTypes() {
        return JsTypes.NULL;
    }

    @Override
    public void traverse(ValueVisitor visitor) throws JsVisitException {
        visitor.visitValue(this);
    }

    public int hashCode() {
        return 982451653;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof JsNull;
    }

    @Override
    public int compareTo(JsNull value) throws NullPointerException {
        if (value == null) {
            throw new NullPointerException();
        }
        return 0;
    }

    public String toString() {
        return TEXT;
    }
}

