/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jovsonz;

public class JsParseException
extends Exception {
    static final String ERRMSG_INVALIDTOKEN = "invalid JSON token";
    static final String ERRMSG_INVALIDROOT = "top root JSON value must be OBJECT or ARRAY";
    static final String ERRMSG_NODATA = "We need but no more JSON data";
    private static final int LINE_UNKNOWN = 0;
    private final int lineNumber;

    public JsParseException() {
        this(null, 0);
    }

    public JsParseException(String message, int lineNumber) {
        this(message, null, lineNumber);
    }

    public JsParseException(String message, Throwable cause, int lineNumber) {
        super(message, cause);
        this.lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean hasValidLineNumber() {
        return this.lineNumber > 0;
    }

    @Override
    public String getMessage() {
        StringBuilder message = new StringBuilder();
        String superMessage = super.getMessage();
        if (superMessage != null) {
            message.append(superMessage);
        }
        if (this.hasValidLineNumber()) {
            if (message.length() > 0) {
                message.append(' ');
            }
            message.append("[line:").append(this.lineNumber).append(']');
        }
        if (message.length() <= 0) {
            return null;
        }
        return message.toString();
    }
}

