/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jovsonz;

import java.io.IOException;
import java.io.Reader;
import jp.sourceforge.jovsonz.JsArray;
import jp.sourceforge.jovsonz.JsBoolean;
import jp.sourceforge.jovsonz.JsComposition;
import jp.sourceforge.jovsonz.JsNull;
import jp.sourceforge.jovsonz.JsNumber;
import jp.sourceforge.jovsonz.JsObject;
import jp.sourceforge.jovsonz.JsParseException;
import jp.sourceforge.jovsonz.JsString;
import jp.sourceforge.jovsonz.JsValue;
import jp.sourceforge.jovsonz.JsVisitException;
import jp.sourceforge.jovsonz.JsonAppender;
import jp.sourceforge.jovsonz.JsonSource;

public final class Json {
    public static final String MIME_TYPE = "application/json";

    private Json() {
        assert (false);
        throw new AssertionError();
    }

    public static void dumpJson(Appendable appout, JsComposition<?> topValue) throws NullPointerException, JsVisitException, IOException {
        if (appout == null || topValue == null) {
            throw new NullPointerException();
        }
        JsonAppender appender = new JsonAppender(appout);
        try {
            topValue.traverse(appender);
        }
        catch (JsVisitException e) {
            assert (appender.hasIOException());
            throw appender.getIOException();
        }
    }

    static JsValue parseValue(JsonSource source) throws IOException, JsParseException {
        source.skipWhiteSpace();
        if (!source.hasMore()) {
            return null;
        }
        JsValue result = JsObject.parseObject(source);
        if (result != null) {
            return result;
        }
        result = JsArray.parseArray(source);
        if (result != null) {
            return result;
        }
        result = JsString.parseString(source);
        if (result != null) {
            return result;
        }
        result = JsNull.parseNull(source);
        if (result != null) {
            return result;
        }
        result = JsBoolean.parseBoolean(source);
        if (result != null) {
            return result;
        }
        result = JsNumber.parseNumber(source);
        if (result == null) {
            throw new JsParseException("invalid JSON token", source.getLineNumber());
        }
        return result;
    }

    private static JsComposition<?> parseJson(JsonSource source) throws IOException, JsParseException {
        JsValue topValue = Json.parseValue(source);
        if (topValue == null) {
            return null;
        }
        if (!(topValue instanceof JsComposition)) {
            throw new JsParseException("top root JSON value must be OBJECT or ARRAY", source.getLineNumber());
        }
        JsComposition result = (JsComposition)topValue;
        return result;
    }

    public static JsComposition<?> parseJson(Reader source) throws IOException, JsParseException {
        JsonSource jsonSource = new JsonSource(source);
        return Json.parseJson(jsonSource);
    }
}

