/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jovsonz;

import java.io.Flushable;
import java.io.IOException;
import java.util.EmptyStackException;
import java.util.Stack;
import jp.sourceforge.jovsonz.JsComposition;
import jp.sourceforge.jovsonz.JsString;
import jp.sourceforge.jovsonz.JsTypes;
import jp.sourceforge.jovsonz.JsValue;
import jp.sourceforge.jovsonz.JsVisitException;
import jp.sourceforge.jovsonz.ValueVisitor;

class JsonAppender
implements ValueVisitor {
    public static final String NEWLINE = "\n";
    public static final String INDENT_UNIT = "  ";
    public static final String PAIR_SEPARATOR = " : ";
    public static final String COMMA = " ,";
    public static final String EMPTY = " ";
    private final Appendable appout;
    private final Stack<DumpContext> contextStack = new Stack();
    private IOException ioException = null;

    public JsonAppender(Appendable appout) throws NullPointerException {
        if (appout == null) {
            throw new NullPointerException();
        }
        this.appout = appout;
    }

    protected void pushComposition(JsComposition<?> composition) {
        DumpContext context = new DumpContext(composition);
        this.contextStack.push(context);
    }

    protected JsComposition<?> popComposition() throws EmptyStackException {
        DumpContext context = this.contextStack.pop();
        JsComposition<?> composition = context.getComposition();
        return composition;
    }

    protected int nestDepth() {
        return this.contextStack.size();
    }

    protected boolean isNestEmpty() {
        return this.contextStack.isEmpty();
    }

    protected boolean hasChildDumped() {
        if (this.isNestEmpty()) {
            return false;
        }
        boolean result = this.contextStack.peek().hasChildDumped();
        return result;
    }

    protected void setChildDumped() {
        if (this.isNestEmpty()) {
            return;
        }
        this.contextStack.peek().setChildDumped();
    }

    protected boolean isArrayContext() {
        if (this.isNestEmpty()) {
            return false;
        }
        DumpContext context = this.contextStack.peek();
        JsComposition<?> composition = context.getComposition();
        JsTypes type = composition.getJsTypes();
        return type == JsTypes.ARRAY;
    }

    protected void append(char ch) throws JsVisitException {
        try {
            this.appout.append(ch);
        }
        catch (IOException e) {
            this.ioException = e;
            throw new JsVisitException(e);
        }
    }

    protected void append(CharSequence seq) throws JsVisitException {
        try {
            this.appout.append(seq);
        }
        catch (IOException e) {
            this.ioException = e;
            throw new JsVisitException(e);
        }
    }

    protected void flush() throws JsVisitException {
        try {
            if (this.appout instanceof Flushable) {
                ((Flushable)((Object)this.appout)).flush();
            }
        }
        catch (IOException e) {
            this.ioException = e;
            throw new JsVisitException(e);
        }
    }

    public IOException getIOException() {
        return this.ioException;
    }

    public boolean hasIOException() {
        return this.ioException != null;
    }

    protected void putPairName(String name) throws JsVisitException {
        try {
            JsString.dumpString(this.appout, name);
        }
        catch (IOException e) {
            this.ioException = e;
            throw new JsVisitException(e);
        }
    }

    protected void putPairSeparator() throws JsVisitException {
        this.append(PAIR_SEPARATOR);
    }

    protected void putComma() throws JsVisitException {
        this.append(COMMA);
    }

    protected void putNewLine() throws JsVisitException {
        this.append(NEWLINE);
    }

    protected void putIndent() throws JsVisitException {
        int level = this.nestDepth();
        for (int ct = 1; ct <= level; ++ct) {
            this.append(INDENT_UNIT);
        }
    }

    protected void putBefore1stElement() throws JsVisitException {
        this.putNewLine();
        this.putIndent();
    }

    protected void putBetweenElement() throws JsVisitException {
        this.putComma();
        this.putNewLine();
        this.putIndent();
    }

    protected void putAfterLastElement() throws JsVisitException {
        this.putNewLine();
        this.putIndent();
    }

    protected void putEmptyElement() throws JsVisitException {
        this.append(EMPTY);
    }

    protected void putBeforeParse() throws JsVisitException {
    }

    protected void putAfterParse() throws JsVisitException {
        this.putNewLine();
    }

    @Override
    public void visitValue(JsValue value) throws JsVisitException {
        if (this.isNestEmpty()) {
            this.putBeforeParse();
        }
        if (this.isArrayContext()) {
            if (this.hasChildDumped()) {
                this.putBetweenElement();
            } else {
                this.putBefore1stElement();
            }
        }
        JsTypes type = value.getJsTypes();
        switch (type) {
            case OBJECT: {
                this.append('{');
                break;
            }
            case ARRAY: {
                this.append('[');
                break;
            }
            default: {
                this.append(value.toString());
            }
        }
        this.setChildDumped();
        if (type.isComposition()) {
            assert (value instanceof JsComposition);
            JsComposition composition = (JsComposition)value;
            this.pushComposition(composition);
        }
    }

    @Override
    public void visitPairName(String pairName) throws JsVisitException {
        if (this.hasChildDumped()) {
            this.putBetweenElement();
        } else {
            this.putBefore1stElement();
        }
        this.putPairName(pairName);
        this.putPairSeparator();
        this.setChildDumped();
    }

    @Override
    public void visitCompositionClose(JsComposition<?> closed) throws JsVisitException {
        char closeBrace;
        boolean hasDumped = this.hasChildDumped();
        JsComposition<?> composition = this.popComposition();
        if (hasDumped) {
            this.putAfterLastElement();
        } else {
            this.putEmptyElement();
        }
        switch (composition.getJsTypes()) {
            case OBJECT: {
                closeBrace = '}';
                break;
            }
            case ARRAY: {
                closeBrace = ']';
                break;
            }
            default: {
                assert (false);
                throw new AssertionError();
            }
        }
        this.append(closeBrace);
        if (this.isNestEmpty()) {
            this.putAfterParse();
            this.flush();
        }
    }

    private static class DumpContext {
        private final JsComposition<?> composition;
        private boolean childDumped;

        DumpContext(JsComposition<?> composition) {
            this.composition = composition;
            this.childDumped = false;
        }

        JsComposition<?> getComposition() {
            return this.composition;
        }

        boolean hasChildDumped() {
            return this.childDumped;
        }

        void setChildDumped() {
            this.childDumped = true;
        }
    }
}

