/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jirc;

import jp.sourceforge.jirc.Channel;
import jp.sourceforge.jirc.Client;
import jp.sourceforge.jirc.IRC;

abstract class AbstractClient
implements Client {
    private String ENC = "JIS";
    protected IRC irc = null;

    AbstractClient() {
    }

    public void Connection(String server, int port, String nick, String user, String passwd) throws Exception {
        try {
            this.irc = new IRC(server, port, nick, user, passwd);
            this.irc.addReadMessageListener(this);
            this.irc.start();
        }
        catch (Exception e) {
            this.irc = null;
            throw e;
        }
    }

    public boolean isConnected() {
        if (this.irc == null) {
            return false;
        }
        return this.irc.isConnected();
    }

    public void Disconnection() {
        try {
            this.irc.QUIT();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void setENC(String encoding) {
        this.ENC = encoding;
    }

    public final String getENC() {
        return this.ENC;
    }

    public void writeMessage(String channel, String message) throws Exception {
        if (message.startsWith("/")) {
            message = message.substring(message.indexOf("/") + 1);
            this.irc.directMessage(this.toENC(message));
        } else if (channel != null) {
            this.irc.PRIVMSG(this.toENC(channel), this.toENC(message));
            this.irc.getChannel(channel).append("<" + this.irc.getNick() + "> " + message);
        }
    }

    public String toENC(String string) {
        try {
            return new String(string.getBytes(this.ENC));
        }
        catch (Exception e) {
            e.printStackTrace();
            return string;
        }
    }

    public String encToUNICODE(String string) {
        try {
            return new String(string.getBytes(), this.ENC);
        }
        catch (Exception e) {
            e.printStackTrace();
            return string;
        }
    }

    public final void setJOIN(String channel) {
        if (channel != null) {
            try {
                this.irc.JOIN(this.toENC(channel));
            }
            catch (Exception e) {
                this.Disconnection();
            }
        }
    }

    public final void setPART(Channel channel) {
        try {
            channel.getIRC().PART(this.toENC(channel.getName()));
        }
        catch (Exception e) {
            this.Disconnection();
        }
    }

    public void setTOPIC(Channel channel, String topic) {
        if (topic != null) {
            try {
                channel.getIRC().TOPIC(channel.getName(), this.toENC(topic));
            }
            catch (Exception e) {
                this.Disconnection();
            }
        }
    }

    public void setNICK(String nick) {
        if (nick != null) {
            try {
                this.irc.NICK(nick);
            }
            catch (Exception e) {
                this.Disconnection();
            }
        }
    }

    public abstract void exit();

    public abstract void changeUser(IRC var1, String var2, String var3);

    public abstract void removeUser(IRC var1, String var2, String var3);

    public abstract void removeChannel(Channel var1);

    public abstract Channel makeChannel(String var1);

    public abstract Channel makeServerChannel(String var1);

    public abstract void append(Channel var1, String var2);

    public abstract void setConnection(IRC var1, boolean var2);
}

