/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jirc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jp.sourceforge.jirc.Channel;
import jp.sourceforge.jirc.ChannelMode;
import jp.sourceforge.jirc.IRC;
import jp.sourceforge.jirc.IRCMessageFormat;
import jp.sourceforge.jirc.Window;

class ChildWindow
extends JPanel
implements Channel {
    private String CRLF = "\r\n";
    private String name;
    private ChannelMode mode;
    private String topic = "";
    private IRC irc;
    private Window window;
    private JScrollBar scrollBar;
    private JTextArea ta;

    ChildWindow(String name, IRC irc, Window window) {
        super(new BorderLayout());
        this.name = name;
        this.irc = irc;
        this.window = window;
        this.mode = new ChannelMode(this);
        this.ta = this.getJTA(15, 10);
        JScrollPane scrollPane = new JScrollPane(this.ta, 22, 31);
        this.scrollBar = scrollPane.getVerticalScrollBar();
        this.add((Component)scrollPane, "Center");
    }

    public IRC getIRC() {
        return this.irc;
    }

    private JTextArea getJTA(int rows, int columns) {
        JTextArea ta = new JTextArea(rows, columns);
        ta.setLineWrap(true);
        ta.setEditable(false);
        return ta;
    }

    public void append(String message) {
        this.ta.append(this.getTime() + " " + message + this.CRLF);
        this.scrollBar.setValue(this.scrollBar.getMaximum());
    }

    private String getTime() {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm");
        return formatter.format(new Date());
    }

    public String toString() {
        return this.name;
    }

    void setChannelName(String name) {
        this.name = name;
        this.window.setTopic();
    }

    public ChannelMode getMode() {
        return this.mode;
    }

    public void setMode(String nick, String modeString) {
        String[] args = new String[]{nick, this.name, modeString};
        this.append(IRCMessageFormat.getModeMessage(args));
        this.setMode(modeString);
    }

    public void setMode(String modeString) {
        boolean flag = false;
        String modes = modeString;
        Vector<String> value = null;
        int valueCount = 0;
        if (modeString.indexOf(32) > 0) {
            value = new Vector<String>();
            StringTokenizer st = new StringTokenizer(modeString, " ", false);
            modes = st.nextToken().trim();
            while (st.hasMoreTokens()) {
                value.add(st.nextToken().trim());
            }
        }
        int i = 0;
        while (i < modes.length()) {
            switch (modes.charAt(i)) {
                case '+': {
                    flag = true;
                    break;
                }
                case '-': {
                    flag = false;
                    break;
                }
                case 'O': {
                    break;
                }
                case 'o': {
                    this.setChanop((String)value.get(valueCount++), flag);
                    break;
                }
                case 'v': {
                    this.setVoice((String)value.get(valueCount++), flag);
                    break;
                }
                case 'a': {
                    this.mode.setAnonymous(flag);
                    break;
                }
                case 'i': {
                    this.mode.setInvite(flag);
                    break;
                }
                case 'm': {
                    this.mode.setModeration(flag);
                    break;
                }
                case 'n': {
                    this.mode.setNotice(flag);
                    break;
                }
                case 'q': {
                    break;
                }
                case 'p': {
                    this.mode.setPrivate(flag);
                    break;
                }
                case 's': {
                    this.mode.setSecret(flag);
                    break;
                }
                case 'r': {
                    this.mode.setReop(flag);
                    break;
                }
                case 't': {
                    this.mode.setTopic(flag);
                    break;
                }
                case 'k': {
                    this.mode.setKeyword((String)value.get(valueCount++), flag);
                    break;
                }
                case 'l': {
                    this.mode.setLimit((String)value.get(valueCount++), flag);
                    break;
                }
                case 'b': {
                    break;
                }
                case 'e': {
                    break;
                }
                case 'I': {
                    break;
                }
            }
            ++i;
        }
        this.window.setTopic();
    }

    public boolean hasTopic() {
        return !this.topic.equals("");
    }

    public void setTopic(String topic) {
        this.topic = topic;
        this.window.setTopic();
    }

    public String getTopic() {
        return this.topic;
    }

    public void writeMessage(String string) {
        this.window.writeMessage(this.name, string);
    }

    public void addUser(String nick) {
        this.window.addUser(this, nick);
    }

    public void removeUser(String nick) {
        this.window.removeUser(this, nick);
    }

    public void setChanop(String nick, boolean flag) {
        this.window.setChanop(this, nick, flag);
    }

    public void setVoice(String nick, boolean flag) {
        this.window.setVoice(this, nick, flag);
    }
}

