/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jirc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import jp.sourceforge.jirc.Channel;
import jp.sourceforge.jirc.Client;
import jp.sourceforge.jirc.CommandMap;
import jp.sourceforge.jirc.IRCIO;

public final class IRC {
    private boolean connected = false;
    private String nick = null;
    private String user = null;
    private String pass = null;
    private String server = null;
    private IRCIO io;
    private Client client = null;
    private CommandMap commandMap = new CommandMap(this);
    private Date date;
    private final Hashtable channelList = new Hashtable();
    private final String CRLF = "\r\n";

    IRC(String server, int port, String nick, String user, String pass) throws Exception {
        String localhost = null;
        InetAddress address = null;
        try {
            try {
                address = InetAddress.getLocalHost();
                localhost = address.getHostName();
            }
            catch (UnknownHostException e) {
                localhost = "unknown";
                Object var10_9 = null;
                address = null;
            }
            Object var10_8 = null;
            address = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            address = null;
            throw throwable;
        }
        this.nick = nick;
        this.user = new String(nick + " " + localhost + " " + server + " :" + user);
        this.pass = pass;
        this.server = server;
        try {
            this.io = new IRCIO(server, port);
        }
        catch (Exception e) {
            this.io = null;
            throw e;
        }
        this.date = new Date();
    }

    public boolean isConnected() {
        return this.connected;
    }

    protected void setConnected(boolean flag) {
        this.connected = flag;
        this.client.setConnection(this, flag);
    }

    public final void start() throws IOException {
        this.addChannel(this.client.makeServerChannel(this, this.server));
        this.io.addReadMessageListener(this);
        this.io.start();
        if (this.pass.length() > 0) {
            this.PASS(this.pass);
        }
        this.USER(this.user);
        this.NICK(this.nick);
    }

    public final void close() {
        this.setConnected(false);
        this.io.close();
    }

    public String getNick() {
        return this.nick;
    }

    protected void setNick(String nick) {
        this.nick = nick;
    }

    protected void changeNick(String oldNick, String newNick) {
        if (oldNick.equalsIgnoreCase(this.nick)) {
            this.setNick(newNick);
        }
        this.client.changeUser(this, oldNick, newNick);
    }

    protected void removeNick(String nick, String message) {
        if (!nick.equalsIgnoreCase(this.nick)) {
            this.client.removeUser(this, nick, message);
        }
    }

    public String getServer() {
        return this.server;
    }

    public Client getClient() {
        return this.client;
    }

    public Date getDate() {
        return this.date;
    }

    public void addReadMessageListener(Client client) {
        this.client = client;
    }

    public Channel makeChannel(String name) {
        Channel channel = this.client.makeChannel(this, name);
        this.addChannel(channel);
        return channel;
    }

    void addChannel(Channel channel) {
        this.channelList.put(channel.toString(), channel);
    }

    public void removeChannel(Channel channel) {
        this.client.removeChannel(channel);
        this.channelList.remove(channel);
    }

    public Channel getChannel(String name) {
        return (Channel)this.channelList.get(name);
    }

    public Enumeration getChannels() {
        return this.channelList.elements();
    }

    public void readMessage(String string) {
        StringTokenizer st = new StringTokenizer(string, " ", false);
        String prefix = "";
        if (string.startsWith(":")) {
            prefix = st.nextToken();
        }
        String command = st.nextToken();
        String params = this.client.encToUNICODE(st.nextToken("\r\n").trim());
        st = null;
        if (!command.equals("PING")) {
            System.out.println(string);
        }
        if (command.length() == 3) {
            this.commandMap.getCommand("NUMERICREPLY").execute(command, params);
        } else if (prefix.equals("")) {
            this.commandMap.getCommand(command).execute(params);
        } else {
            this.commandMap.getCommand(command).execute(prefix, params);
        }
    }

    public final void writeMessage(String message) throws IOException {
        this.io.writeMessage(message + "\r\n");
    }

    public void directMessage(String message) throws IOException {
        this.writeMessage(message);
    }

    public void NICK(String nick) throws IOException {
        this.writeMessage("NICK " + nick);
    }

    public void USER(String message) throws IOException {
        this.writeMessage("USER " + message);
    }

    public void PASS(String pass) throws IOException {
        this.writeMessage("PASS " + pass);
        pass = null;
    }

    public void PRIVMSG(String channel, String message) throws IOException {
        this.writeMessage("PRIVMSG " + channel + " :" + message);
    }

    public void NOTICE(String channel, String message) throws IOException {
        this.writeMessage("NOTICE " + channel + " :" + message);
    }

    public void PONG(String message) throws IOException {
        this.writeMessage("PONG " + message);
    }

    public void JOIN(String message) throws IOException {
        this.writeMessage("JOIN " + message);
    }

    public void MODE(String message) throws IOException {
        this.writeMessage("MODE " + message);
    }

    protected void protectedMODE(String message) throws IOException {
        this.writeMessage("MODE " + this.client.toENC(message));
    }

    public void PART(String message) throws IOException {
        this.writeMessage("PART " + message);
    }

    public void TOPIC(String channel, String topic) throws IOException {
        this.writeMessage("TOPIC " + this.client.toENC(channel) + " :" + topic);
    }

    public void QUIT() throws IOException {
        this.writeMessage("QUIT");
    }
}

