/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jirc;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import jp.sourceforge.jirc.ClientMessage;
import jp.sourceforge.jirc.Window;

class ConnectionDialog
extends JDialog {
    private final String PROPERTIES = ".jIRC";
    private final String SERVER = ".jIRC.server";
    private final String PORT = ".jIRC.port";
    private final String NICK = ".jIRC.nick";
    private final String CHANNELS = ".jIRC.channels";
    private Properties properties = new Properties();
    private final Window client;
    private JTextField serverTextField;
    private JTextField portTextField;
    private JTextField nickTextField;
    private JPasswordField passwordField;
    private JTextField channelsTextField;

    ConnectionDialog(Window client) {
        this.client = client;
        try {
            this.properties.load(new FileInputStream(".jIRC"));
        }
        catch (FileNotFoundException e) {
            this.properties.setProperty(".jIRC.server", "");
            this.properties.setProperty(".jIRC.port", "6667");
            this.properties.setProperty(".jIRC.nick", "");
            this.properties.setProperty(".jIRC.channels", "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getContentPane().add((Component)this.getTextPanel(), "East");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
        this.show();
        this.serverTextField.requestFocus();
    }

    private JPanel getTextPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        this.serverTextField = new JTextField(this.properties.getProperty(".jIRC.server"), 20);
        this.portTextField = new JTextField(this.properties.getProperty(".jIRC.port"));
        this.nickTextField = new JTextField(this.properties.getProperty(".jIRC.nick"));
        this.passwordField = new JPasswordField("");
        this.channelsTextField = new JTextField(this.properties.getProperty(".jIRC.channels"));
        this.serverTextField.setNextFocusableComponent(this.portTextField);
        this.portTextField.setNextFocusableComponent(this.nickTextField);
        this.nickTextField.setNextFocusableComponent(this.passwordField);
        this.addComponent(panel, constraints, new Insets(12, 12, 0, 7), 0, 0, this.getJLabel(ClientMessage.getMessage("server")));
        this.addComponent(panel, constraints, new Insets(12, 0, 0, 11), 1, 0, this.serverTextField);
        this.addComponent(panel, constraints, new Insets(5, 12, 0, 7), 0, 1, this.getJLabel(ClientMessage.getMessage("port")));
        this.addComponent(panel, constraints, new Insets(5, 0, 0, 11), 1, 1, this.portTextField);
        this.addComponent(panel, constraints, new Insets(5, 12, 0, 7), 0, 2, this.getJLabel(ClientMessage.getMessage("nick")));
        this.addComponent(panel, constraints, new Insets(5, 0, 0, 11), 1, 2, this.nickTextField);
        this.addComponent(panel, constraints, new Insets(5, 12, 0, 7), 0, 3, this.getJLabel(ClientMessage.getMessage("password")));
        this.addComponent(panel, constraints, new Insets(5, 0, 0, 11), 1, 3, this.passwordField);
        this.addComponent(panel, constraints, new Insets(5, 12, 0, 7), 0, 4, this.getJLabel(ClientMessage.getMessage("channel")));
        this.addComponent(panel, constraints, new Insets(5, 0, 0, 11), 1, 4, this.channelsTextField);
        return panel;
    }

    private JLabel getJLabel(String title) {
        JLabel label = new JLabel(title, 4);
        label.setRequestFocusEnabled(false);
        return label;
    }

    private JPanel getButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout());
        JButton OKButton = new JButton(ClientMessage.getMessage("connection"));
        JButton CancelButton = new JButton(ClientMessage.getMessage("cancel"));
        OKButton.addActionListener(new DialogOKListener());
        CancelButton.addActionListener(new DialogCancelListener());
        panel.add(OKButton);
        panel.add(CancelButton);
        return panel;
    }

    private void addComponent(Container container, GridBagConstraints constraints, Insets insets, int gridx, int gridy, Component component) {
        constraints.insets = insets;
        constraints.gridx = gridx;
        constraints.gridy = gridy;
        container.add(component, constraints);
    }

    public void OKAction() {
        String server = this.serverTextField.getText();
        String port = this.portTextField.getText();
        String nick = this.nickTextField.getText();
        String channels = this.channelsTextField.getText();
        this.properties.setProperty(".jIRC.server", server);
        this.properties.setProperty(".jIRC.port", port);
        this.properties.setProperty(".jIRC.nick", nick);
        this.properties.setProperty(".jIRC.channels", channels);
        Integer num = new Integer(port);
        try {
            if (channels.length() > 0) {
                this.client.Connection(server, num, nick, "jIRC", new String(this.passwordField.getPassword()), channels);
            } else {
                this.client.Connection(server, num, nick, "jIRC", new String(this.passwordField.getPassword()));
            }
            this.setVisible(false);
            if (this.properties != null) {
                this.properties.store(new FileOutputStream(".jIRC"), ".jIRC");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void CancelAction() {
        this.setVisible(false);
    }

    private class DialogCancelListener
    implements ActionListener {
        private DialogCancelListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            ConnectionDialog.this.CancelAction();
        }
    }

    private class DialogOKListener
    implements ActionListener {
        private DialogOKListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            ConnectionDialog.this.OKAction();
        }
    }
}

