/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jirc;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import jp.sourceforge.jirc.ChildWindow;
import jp.sourceforge.jirc.Window;
import jp.sourceforge.jirc.net.Channel;

class WindowTreeModel
extends DefaultTreeModel {
    private static MutableTreeNode rootNode = new DefaultMutableTreeNode();
    private Hashtable serverTable = new Hashtable();
    private Hashtable nodeTable = new Hashtable();
    private Window window;

    public WindowTreeModel(Window window) {
        super(rootNode);
        this.window = window;
    }

    public synchronized void addParentWindow(ChildWindow cw) {
        DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(cw);
        rootNode.insert(treeNode, rootNode.getChildCount());
        this.nodeTable.put(cw.getIRC().getServer(), treeNode);
        this.serverTable.put(cw.toString(), cw);
        this.window.setChannel(cw);
        this.reload(rootNode);
    }

    public synchronized void removeParentWindow() {
        Enumeration e = this.serverTable.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            ChildWindow cw = (ChildWindow)this.serverTable.get(name);
            if (cw.getIRC().isConnected()) continue;
            String string = cw.getIRC().getServer();
            MutableTreeNode treeNode = (MutableTreeNode)this.nodeTable.get(string);
            rootNode.remove(treeNode);
            this.nodeTable.remove(this.nodeTable.get(string));
            this.serverTable.remove(cw);
        }
        this.reload(rootNode);
    }

    public synchronized void addChannel(ChildWindow cw) {
        MutableTreeNode serverNode = (MutableTreeNode)this.nodeTable.get(cw.getIRC().getServer());
        DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(cw);
        serverNode.insert(treeNode, serverNode.getChildCount());
        this.nodeTable.put(cw.getIRC().getServer() + cw, treeNode);
        this.window.setChannel(cw);
        this.reload(serverNode);
    }

    public void removeChannel(Channel channel) {
        MutableTreeNode treeNode = (MutableTreeNode)this.nodeTable.get(channel.getIRC().getServer() + channel);
        if (treeNode != null) {
            this.nodeTable.remove(channel.getIRC().getServer() + channel);
            MutableTreeNode serverNode = (MutableTreeNode)this.nodeTable.get(channel.getIRC().getServer());
            serverNode.remove(treeNode);
            ChildWindow cw = (ChildWindow)this.serverTable.get(channel);
            if (cw == null) {
                cw = (ChildWindow)channel;
            }
            this.window.removeWindow(cw);
            this.reload(rootNode);
        }
    }

    void renameChannel(Channel channel, String newName) {
        ChildWindow childWindow = (ChildWindow)channel;
        childWindow.setChannelName(newName);
    }

    public Channel getNowServer() {
        Channel nowChannel = this.window.getNowChannel();
        Channel channel = (Channel)this.serverTable.get(nowChannel.toString());
        if (channel == null) {
            channel = (Channel)this.serverTable.get(nowChannel.getIRC().getServer());
        }
        return channel;
    }

    public void addUser(Channel channel, String nick) {
        MutableTreeNode treeNode = this.getChannelTreeNode(channel);
        if (treeNode != null && !this.hasUser(treeNode, nick)) {
            treeNode.insert(new DefaultMutableTreeNode(nick), treeNode.getChildCount());
            this.reload(treeNode);
        }
    }

    public boolean removeUser(Channel channel, String nick) {
        MutableTreeNode treeNode = this.getChannelTreeNode(channel);
        if (treeNode == null) {
            return false;
        }
        MutableTreeNode userNode = this.getUserNode(treeNode, nick);
        if (userNode != null) {
            treeNode.remove(userNode);
            this.reload(treeNode);
            return true;
        }
        return false;
    }

    private boolean hasUser(MutableTreeNode treeNode, String nick) {
        Enumeration<? extends TreeNode> e = treeNode.children();
        if (e != null) {
            while (e.hasMoreElements()) {
                MutableTreeNode childNode = (MutableTreeNode)e.nextElement();
                if (!childNode.toString().equals(nick)) continue;
                return true;
            }
        }
        return false;
    }

    void changeUserNode(MutableTreeNode channel, MutableTreeNode oldNick, String newNick) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(newNick);
        channel.remove(oldNick);
        channel.insert(node, channel.getChildCount());
        this.reload(channel);
    }

    MutableTreeNode getUserNode(MutableTreeNode treeNode, String nick) {
        Enumeration<? extends TreeNode> e = treeNode.children();
        while (e.hasMoreElements()) {
            MutableTreeNode childNode = (MutableTreeNode)e.nextElement();
            String user = childNode.toString();
            if (!user.equals(nick) && !user.equals("@" + nick) && !user.equals("+" + nick)) continue;
            return childNode;
        }
        return null;
    }

    void setUserMode(Channel channel, String nick, String mode, boolean flag) {
        MutableTreeNode childNode;
        MutableTreeNode treeNode = this.getChannelTreeNode(channel);
        if (treeNode != null && (childNode = this.getUserNode(treeNode, nick)) != null) {
            if (flag) {
                nick = mode + nick;
            }
            this.changeUserNode(treeNode, childNode, nick);
        }
    }

    MutableTreeNode getChannelTreeNode(Channel channel) {
        return (MutableTreeNode)this.nodeTable.get(channel.getIRC().getServer() + channel);
    }
}

