/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jirc.net;

import jp.sourceforge.jirc.net.Channel;
import jp.sourceforge.jirc.net.Client;
import jp.sourceforge.jirc.net.IRC;
import jp.sourceforge.jirc.text.IRCMessageFormat;

public abstract class AbstractClient
implements Client {
    private String ENC = "JIS";

    public IRC Connection(String server, int port, String nick, String user, String passwd) throws Exception {
        IRC irc = null;
        try {
            irc = new IRC(server, port, nick, user, passwd);
            irc.addReadMessageListener(this);
            irc.start();
        }
        catch (Exception e) {
            irc = null;
            throw e;
        }
        return irc;
    }

    public abstract IRC getIRC();

    public boolean isConnected() {
        IRC irc = this.getIRC();
        if (irc == null) {
            return false;
        }
        return irc.isConnected();
    }

    public void Disconnection() {
        IRC irc = this.getIRC();
        try {
            if (irc.isConnected()) {
                irc.QUIT();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        IRC irc = this.getIRC();
        if (irc != null) {
            irc.close();
        }
    }

    public final void setENC(String encoding) {
        this.ENC = encoding;
    }

    public final String getENC() {
        return this.ENC;
    }

    public void writeMessage(String channel, String message) throws Exception {
        IRC irc = this.getIRC();
        if (message.startsWith("/")) {
            message = message.substring(message.indexOf("/") + 1);
            irc.directMessage(this.toENC(message));
        } else if (channel != null) {
            irc.PRIVMSG(this.toENC(channel), this.toENC(message));
            String[] args = new String[]{irc.getNick(), channel, message};
            irc.getChannel(channel).append(IRCMessageFormat.getPrivmsgMessage(args));
        }
    }

    public String toENC(String string) {
        try {
            return new String(string.getBytes(this.ENC));
        }
        catch (Exception e) {
            e.printStackTrace();
            return string;
        }
    }

    public String encToUNICODE(String string) {
        try {
            return new String(string.getBytes(), this.ENC);
        }
        catch (Exception e) {
            e.printStackTrace();
            return string;
        }
    }

    public final void setJOIN(String channel) {
        block2: {
            IRC irc = this.getIRC();
            if (channel == null) break block2;
            try {
                irc.JOIN(this.toENC(channel));
            }
            catch (Exception e) {
                this.Disconnection();
            }
        }
    }

    public final void setPART(Channel channel) {
        try {
            channel.getIRC().PART(this.toENC(channel.toString()));
        }
        catch (Exception e) {
            this.Disconnection();
        }
    }

    public void setTOPIC(Channel channel, String topic) {
        block2: {
            if (topic == null) break block2;
            try {
                channel.getIRC().TOPIC(channel.toString(), this.toENC(topic));
            }
            catch (Exception e) {
                this.Disconnection();
            }
        }
    }

    public void setNICK(String nick) {
        block2: {
            IRC irc = this.getIRC();
            if (nick == null) break block2;
            try {
                irc.NICK(nick);
            }
            catch (Exception e) {
                this.Disconnection();
            }
        }
    }

    public void setException(Exception e) {
        e.printStackTrace();
    }
}

