/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jlogtest;

import jp.sourceforge.jlogtest.ILog;
import jp.sourceforge.jlogtest.util.java.HashGen;
import jp.sourceforge.jlogtest.util.xom.ChildSelector;
import jp.sourceforge.jlogtest.util.xom.NodeCreator;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.ParsingException;

public class LogInfo
implements ILog {
    public static final String LOG = "log";
    private static final String NAME = "name";
    private static final String TEXT = "text";
    private final String text;
    private final String name;

    public LogInfo(String text, String name) {
        this.text = text;
        this.name = name;
    }

    public LogInfo(Element log) throws ParsingException {
        if (!LOG.equals(log.getLocalName())) {
            throw new ParsingException("no log element");
        }
        try {
            this.text = LogInfo.getText(log);
            this.name = log.getAttributeValue(NAME);
            if (this.text == null || this.name == null) {
                throw new ParsingException("parse failed");
            }
        }
        catch (Exception e) {
            throw new ParsingException("parse failed", (Throwable)e);
        }
    }

    private static String getText(Element log) throws ParsingException {
        assert (LOG.equals(log.getLocalName()));
        ChildSelector selector = new ChildSelector((ParentNode)log);
        if (!selector.isUnique(TEXT)) {
            throw new ParsingException("no log element");
        }
        Element text = selector.getUniqueElement(TEXT);
        return text.getValue();
    }

    public Element asXml() {
        Element log = new Element(LOG);
        log.addAttribute(new Attribute(NAME, this.name));
        log.appendChild(this.getXmlTextPart());
        return log;
    }

    private Node getXmlTextPart() {
        Element text = new Element(TEXT);
        text.addAttribute(NodeCreator.getPreserveSpaceAttribute());
        text.appendChild(this.text);
        return text;
    }

    public String asOutputString() {
        return String.format("name : %s\ntext : '%s'", this.name, this.text);
    }

    public String getText() {
        return this.text;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LogInfo)) {
            return false;
        }
        LogInfo info = (LogInfo)obj;
        return this.text.equals(info.text) && this.name.equals(info.name);
    }

    public int hashCode() {
        return HashGen.gen(this.text, this.name);
    }
}

