/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jlogtest;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.jlogtest.ILog;
import jp.sourceforge.jlogtest.ILoggable;
import jp.sourceforge.jlogtest.JclLogInfo;
import jp.sourceforge.jlogtest.LogInfo;
import jp.sourceforge.jlogtest.TargetSequence;
import jp.sourceforge.jlogtest.util.xom.SpecificChildElementIterator;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.ParsingException;

public class LogSequence
implements ILoggable {
    public static final String SEQUENCE = "sequence";
    public static final String NAME = "name";
    private final List<ILog> seqElements;
    private final String name;
    private final TargetSequence targetSeq;

    public LogSequence(TargetSequence targetSeq) {
        this.seqElements = new ArrayList<ILog>();
        this.name = targetSeq.getName();
        this.targetSeq = targetSeq;
    }

    public LogSequence(Element sequence) throws ParsingException {
        if (!SEQUENCE.equals(sequence.getLocalName())) {
            throw new ParsingException("no sequence element");
        }
        this.name = sequence.getAttributeValue(NAME);
        if (this.name == null) {
            throw new ParsingException("no name attribute");
        }
        this.seqElements = new ArrayList<ILog>();
        try {
            for (Element child : new SpecificChildElementIterator((ParentNode)sequence, "jcllog", "log")) {
                this.seqElements.add(LogSequence.getLog(child));
            }
        }
        catch (Exception e) {
            throw new ParsingException("parse failed", (Throwable)e);
        }
        this.targetSeq = null;
    }

    private static ILog getLog(Element child) throws ParsingException {
        assert (child != null);
        String name = child.getLocalName();
        if ("jcllog".equals(name)) {
            return new JclLogInfo(child);
        }
        if ("log".equals(name)) {
            return new LogInfo(child);
        }
        assert (false);
        throw new IllegalArgumentException();
    }

    public void addLog(ILog log) {
        if (this.targetSeq.contains(log)) {
            this.seqElements.add(log);
        }
    }

    public ILog[] getLogs() {
        return this.seqElements.toArray(new ILog[0]);
    }

    public String getName() {
        return this.name;
    }

    public Element asXml() {
        return this.createLogsElement();
    }

    private Element createLogsElement() {
        Element sequence = new Element(SEQUENCE);
        if (this.name != null) {
            sequence.addAttribute(new Attribute(NAME, this.name));
        }
        for (ILog aLog : this.seqElements) {
            sequence.appendChild((Node)aLog.asXml());
        }
        return sequence;
    }
}

