/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jlogtest;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import jp.sourceforge.jlogtest.ILog;
import jp.sourceforge.jlogtest.ILoggable;
import jp.sourceforge.jlogtest.LogSequence;
import jp.sourceforge.jlogtest.TargetSequence;
import jp.sourceforge.jlogtest.util.xom.SpecificChildElementIterator;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.ParsingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogTestCase
implements ILoggable {
    private static final String LOG_SEQUENCES = "logSequences";
    private static final String CLASS = "class";
    private static final String METHOD = "method";
    private Set<LogSequence> sequence;
    private final String clazz;
    private final String method;

    public LogTestCase(String testCaseClass, String testCaseMethod) {
        this.sequence = new TreeSet<LogSequence>(new SequenceComparator());
        this.clazz = testCaseClass;
        this.method = testCaseMethod;
    }

    public LogTestCase(Element logSequences) throws ParsingException {
        try {
            this.clazz = logSequences.getAttributeValue(CLASS);
            this.method = logSequences.getAttributeValue(METHOD);
            if (this.clazz == null || this.method == null) {
                throw new ParsingException("parse failed");
            }
            this.sequence = new TreeSet<LogSequence>(new SequenceComparator());
            for (Element child : new SpecificChildElementIterator((ParentNode)logSequences, "sequence")) {
                this.sequence.add(new LogSequence(child));
            }
        }
        catch (Exception e) {
            throw new ParsingException("parse failed", (Throwable)e);
        }
    }

    public void addSequence(TargetSequence tSeq) {
        this.sequence.add(new LogSequence(tSeq));
    }

    @Override
    public void addLog(ILog log) {
        for (LogSequence seq : this.sequence) {
            seq.addLog(log);
        }
    }

    public Map<String, ILog[]> getLogs() {
        HashMap<String, ILog[]> res = new HashMap<String, ILog[]>();
        for (LogSequence seq : this.sequence) {
            res.put(seq.getName(), seq.getLogs());
        }
        return res;
    }

    public Element asXml() {
        return this.createLogSequenceElement();
    }

    private Element createLogSequenceElement() {
        Element logSequences = new Element(LOG_SEQUENCES);
        logSequences.addAttribute(new Attribute(CLASS, this.clazz));
        logSequences.addAttribute(new Attribute(METHOD, this.method));
        for (LogSequence seq : this.sequence) {
            logSequences.appendChild((Node)seq.asXml());
        }
        return logSequences;
    }

    public String getTestCaseClass() {
        return this.clazz;
    }

    public String getTestCaseMethod() {
        return this.method;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SequenceComparator
    implements Comparator<LogSequence> {
        private SequenceComparator() {
        }

        @Override
        public int compare(LogSequence o1, LogSequence o2) {
            if (o1.getName() == null) {
                return -1;
            }
            if (o2.getName() == null) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    }
}

