/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jlogtest;

import java.io.IOException;
import jp.sourceforge.jlogtest.IOperationMode;
import jp.sourceforge.jlogtest.JclReceiver;
import jp.sourceforge.jlogtest.LogTestCase;
import jp.sourceforge.jlogtest.LoggerFactory;
import jp.sourceforge.jlogtest.TargetSequence;
import jp.sourceforge.jlogtest.VerifierContainer;
import jp.sourceforge.jlogtest.XmlFileManipulator;
import nu.xom.ParsingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayMode
implements IOperationMode {
    private final XmlFileManipulator readerWriter;
    private final String testCaseClass;
    private final String testCaseMethod;
    private final VerifierContainer verifier;
    private boolean enableJcl;

    public PlayMode(String pathToDir, Class<?> clazz, String method) throws ParsingException, IOException {
        this.readerWriter = new XmlFileManipulator(pathToDir);
        this.testCaseClass = clazz.getName();
        this.testCaseMethod = method;
        LoggerFactory.reset();
        LogTestCase logTestCase = new LogTestCase(this.readerWriter.input(this.testCaseClass, this.testCaseMethod).getRootElement());
        this.verifier = new VerifierContainer(logTestCase.getLogs());
        this.enableJcl = false;
    }

    @Override
    public void start() throws ParsingException, IOException {
        this.verifier.verifySequence();
        if (this.enableJcl) {
            JclReceiver.setLogger(this.verifier);
        }
        LoggerFactory.setLogger(this.verifier);
    }

    @Override
    public void stop() {
        this.verifier.finish();
    }

    @Override
    public void addTarget(TargetSequence sequence) {
        this.enableJcl = this.enableJcl || sequence.hasJclLog();
        this.verifier.addSequence(sequence);
    }
}

