/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jlogtest;

import java.io.IOException;
import jp.sourceforge.jlogtest.IMessageOutputter;
import jp.sourceforge.jlogtest.IOperationMode;
import jp.sourceforge.jlogtest.JclReceiver;
import jp.sourceforge.jlogtest.LogTestCase;
import jp.sourceforge.jlogtest.LoggerFactory;
import jp.sourceforge.jlogtest.TargetSequence;
import jp.sourceforge.jlogtest.XmlFileManipulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordMode
implements IOperationMode {
    private final LogTestCase logTestCase;
    private final XmlFileManipulator readerWriter;
    private final String testCaseClass;
    private final String testCaseMethod;
    private final IMessageOutputter messageOutputter;
    private boolean enableJcl;

    public RecordMode(String pathToDir, Class<?> clazz, String method, IMessageOutputter messageOutputter) {
        this.readerWriter = new XmlFileManipulator(pathToDir);
        this.testCaseClass = clazz.getName();
        this.testCaseMethod = method;
        this.messageOutputter = messageOutputter;
        LoggerFactory.reset();
        this.logTestCase = new LogTestCase(this.testCaseClass, this.testCaseMethod);
        this.enableJcl = false;
    }

    @Override
    public void start() {
        if (this.enableJcl) {
            JclReceiver.setLogger(this.logTestCase);
        }
        LoggerFactory.setLogger(this.logTestCase);
    }

    @Override
    public void stop() throws IOException {
        this.readerWriter.output(this.logTestCase.asXml(), this.logTestCase.getTestCaseClass(), this.logTestCase.getTestCaseMethod());
        this.notifyRecorded();
    }

    @Override
    public void addTarget(TargetSequence sequence) {
        this.enableJcl = this.enableJcl || sequence.hasJclLog();
        this.logTestCase.addSequence(sequence);
    }

    private void notifyRecorded() {
        String message = "class : " + this.testCaseClass + "\n" + "method : " + this.testCaseMethod + "\n" + "\u306e\u30c6\u30b9\u30c8\u3092\u8a18\u9332\u3057\u307e\u3057\u305f\u3002\n\n";
        this.messageOutputter.output(message);
    }
}

