/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jlogtest;

import java.util.HashSet;
import java.util.Set;
import jp.sourceforge.jlogtest.ILog;
import jp.sourceforge.jlogtest.JclLogInfo;
import jp.sourceforge.jlogtest.JclLogType;
import jp.sourceforge.jlogtest.LogInfo;
import jp.sourceforge.jlogtest.util.java.HashGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetSequence {
    private final String name;
    private final Set<JclLogType> jcl;
    private final Set<String> log;

    public TargetSequence(String name, Set<JclLogType> jcl, Set<String> log) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.jcl = new HashSet<JclLogType>();
        this.jcl.addAll(jcl);
        this.log = new HashSet<String>();
        this.log.addAll(log);
    }

    public boolean hasJclLog() {
        return 0 < this.jcl.size();
    }

    public String getName() {
        return this.name;
    }

    public boolean contains(ILog log) {
        if (log instanceof JclLogInfo) {
            JclLogInfo logInfo = (JclLogInfo)log;
            return this.jcl.contains(new JclLogType(logInfo.getClassName(), logInfo.getJclLogLevel()));
        }
        if (log instanceof LogInfo) {
            LogInfo logInfo = (LogInfo)log;
            return this.log.contains(logInfo.getName());
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TargetSequence)) {
            return false;
        }
        TargetSequence obj2 = (TargetSequence)obj;
        return ((Object)this.jcl).equals(obj2.jcl) && ((Object)this.log).equals(obj2.log) && TargetSequence.isEqual(this.name, obj2.name);
    }

    private static boolean isEqual(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    public int hashCode() {
        return HashGen.gen(this.name, this.jcl, this.log);
    }
}

