/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jlogtest.util.xom;

import java.util.Iterator;
import java.util.NoSuchElementException;
import jp.sourceforge.jlogtest.util.xom.ChildNodeIterator;
import jp.sourceforge.jlogtest.util.xom.NodeEvaluator;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecificChildElementIterator
implements Iterable<Element> {
    private final ParentNode parentNode;
    private final String[] elementNames;

    public SpecificChildElementIterator(ParentNode parentNode, String ... elementNames) {
        this.parentNode = parentNode;
        this.elementNames = elementNames;
    }

    @Override
    public Iterator<Element> iterator() {
        ChildNodeIterator baseIter = new ChildNodeIterator(this.parentNode);
        return new ElementIterator(baseIter, this.elementNames);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ElementIterator
    implements Iterator<Element> {
        private final Iterator<Node> baseIter;
        private final String[] elementNames;
        private ElementOrInvalid next;

        private ElementIterator(Iterable<Node> baseIter, String[] elementNames) {
            this.baseIter = baseIter.iterator();
            this.elementNames = elementNames;
            this.setNextElement();
        }

        @Override
        public boolean hasNext() {
            return this.next.isValid;
        }

        @Override
        public Element next() {
            if (this.next.isValid) {
                Element toReturn = this.next.element;
                this.setNextElement();
                return toReturn;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void setNextElement() {
            while (this.baseIter.hasNext()) {
                Node node = this.baseIter.next();
                if (!ElementIterator.isElementValid(node, this.elementNames)) continue;
                this.next = new ElementOrInvalid((Element)node, true);
                return;
            }
            this.next = new ElementOrInvalid(null, false);
        }

        private static boolean isElementValid(Node node, String[] elementNames) {
            for (String name : elementNames) {
                if (!NodeEvaluator.isElementNamed(node, name)) continue;
                return true;
            }
            return false;
        }

        private static class ElementOrInvalid {
            public final Element element;
            public final boolean isValid;

            public ElementOrInvalid(Element element, boolean isValid) {
                this.element = element;
                this.isValid = isValid;
            }
        }
    }
}

