/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.io.Serializable;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.MatrixIndexException;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.util.MathUtils;

public class RealMatrixImpl
implements RealMatrix,
Serializable {
    private static final long serialVersionUID = 4237564493130426188L;
    private double[][] data = null;
    private double[][] lu = null;
    private int[] permutation = null;
    private int parity = 1;
    protected static double TOO_SMALL = 1.0E-11;

    public RealMatrixImpl() {
    }

    public RealMatrixImpl(int rowDimension, int columnDimension) {
        if (rowDimension <= 0 || columnDimension <= 0) {
            throw new IllegalArgumentException("row and column dimensions must be postive");
        }
        this.data = new double[rowDimension][columnDimension];
        this.lu = null;
    }

    public RealMatrixImpl(double[][] d) {
        this.copyIn(d);
        this.lu = null;
    }

    public RealMatrixImpl(double[] v) {
        int nRows = v.length;
        this.data = new double[nRows][1];
        int row = 0;
        while (row < nRows) {
            this.data[row][0] = v[row];
            ++row;
        }
    }

    public RealMatrix copy() {
        return new RealMatrixImpl(this.copyOut());
    }

    public RealMatrix add(RealMatrix m) throws IllegalArgumentException {
        if (this.getColumnDimension() != m.getColumnDimension() || this.getRowDimension() != m.getRowDimension()) {
            throw new IllegalArgumentException("matrix dimension mismatch");
        }
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        double[][] outData = new double[rowCount][columnCount];
        int row = 0;
        while (row < rowCount) {
            int col = 0;
            while (col < columnCount) {
                outData[row][col] = this.data[row][col] + m.getEntry(row, col);
                ++col;
            }
            ++row;
        }
        return new RealMatrixImpl(outData);
    }

    public RealMatrix subtract(RealMatrix m) throws IllegalArgumentException {
        if (this.getColumnDimension() != m.getColumnDimension() || this.getRowDimension() != m.getRowDimension()) {
            throw new IllegalArgumentException("matrix dimension mismatch");
        }
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        double[][] outData = new double[rowCount][columnCount];
        int row = 0;
        while (row < rowCount) {
            int col = 0;
            while (col < columnCount) {
                outData[row][col] = this.data[row][col] - m.getEntry(row, col);
                ++col;
            }
            ++row;
        }
        return new RealMatrixImpl(outData);
    }

    public RealMatrix scalarAdd(double d) {
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        double[][] outData = new double[rowCount][columnCount];
        int row = 0;
        while (row < rowCount) {
            int col = 0;
            while (col < columnCount) {
                outData[row][col] = this.data[row][col] + d;
                ++col;
            }
            ++row;
        }
        return new RealMatrixImpl(outData);
    }

    public RealMatrix scalarMultiply(double d) {
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        double[][] outData = new double[rowCount][columnCount];
        int row = 0;
        while (row < rowCount) {
            int col = 0;
            while (col < columnCount) {
                outData[row][col] = this.data[row][col] * d;
                ++col;
            }
            ++row;
        }
        return new RealMatrixImpl(outData);
    }

    public RealMatrix multiply(RealMatrix m) throws IllegalArgumentException {
        if (this.getColumnDimension() != m.getRowDimension()) {
            throw new IllegalArgumentException("Matrices are not multiplication compatible.");
        }
        int nRows = this.getRowDimension();
        int nCols = m.getColumnDimension();
        int nSum = this.getColumnDimension();
        double[][] outData = new double[nRows][nCols];
        double sum = 0.0;
        int row = 0;
        while (row < nRows) {
            int col = 0;
            while (col < nCols) {
                sum = 0.0;
                int i = 0;
                while (i < nSum) {
                    sum += this.data[row][i] * m.getEntry(i, col);
                    ++i;
                }
                outData[row][col] = sum;
                ++col;
            }
            ++row;
        }
        return new RealMatrixImpl(outData);
    }

    public RealMatrix preMultiply(RealMatrix m) throws IllegalArgumentException {
        return m.multiply(this);
    }

    public double[][] getData() {
        return this.copyOut();
    }

    public double[][] getDataRef() {
        return this.data;
    }

    public double getNorm() {
        double maxColSum = 0.0;
        int col = 0;
        while (col < this.getColumnDimension()) {
            double sum = 0.0;
            int row = 0;
            while (row < this.getRowDimension()) {
                sum += Math.abs(this.data[row][col]);
                ++row;
            }
            maxColSum = Math.max(maxColSum, sum);
            ++col;
        }
        return maxColSum;
    }

    public RealMatrix getSubMatrix(int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException {
        if (startRow < 0 || startRow > endRow || endRow > this.data.length || startColumn < 0 || startColumn > endColumn || endColumn > this.data[0].length) {
            throw new MatrixIndexException("invalid row or column index selection");
        }
        RealMatrixImpl subMatrix = new RealMatrixImpl(endRow - startRow + 1, endColumn - startColumn + 1);
        double[][] subMatrixData = subMatrix.getDataRef();
        int i = startRow;
        while (i <= endRow) {
            int j = startColumn;
            while (j <= endColumn) {
                subMatrixData[i - startRow][j - startColumn] = this.data[i][j];
                ++j;
            }
            ++i;
        }
        return subMatrix;
    }

    public RealMatrix getSubMatrix(int[] selectedRows, int[] selectedColumns) throws MatrixIndexException {
        if (selectedRows.length * selectedColumns.length == 0) {
            throw new MatrixIndexException("selected row and column index arrays must be non-empty");
        }
        RealMatrixImpl subMatrix = new RealMatrixImpl(selectedRows.length, selectedColumns.length);
        double[][] subMatrixData = subMatrix.getDataRef();
        try {
            int i = 0;
            while (i < selectedRows.length) {
                int j = 0;
                while (j < selectedColumns.length) {
                    subMatrixData[i][j] = this.data[selectedRows[i]][selectedColumns[j]];
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixIndexException("matrix dimension mismatch");
        }
        return subMatrix;
    }

    public void setSubMatrix(double[][] subMatrix, int row, int column) throws MatrixIndexException {
        if (row < 0 || column < 0) {
            throw new MatrixIndexException("invalid row or column index selection");
        }
        int nRows = subMatrix.length;
        if (nRows == 0) {
            throw new IllegalArgumentException("Matrix must have at least one row.");
        }
        int nCols = subMatrix[0].length;
        if (nCols == 0) {
            throw new IllegalArgumentException("Matrix must have at least one column.");
        }
        int r = 1;
        while (r < nRows) {
            if (subMatrix[r].length != nCols) {
                throw new IllegalArgumentException("All input rows must have the same length.");
            }
            ++r;
        }
        if (this.data == null) {
            if (row > 0 || column > 0) {
                throw new MatrixIndexException("matrix must be initialized to perfom this method");
            }
            this.data = new double[nRows][nCols];
            System.arraycopy(subMatrix, 0, this.data, 0, subMatrix.length);
        }
        if (nRows + row > this.getRowDimension() || nCols + column > this.getColumnDimension()) {
            throw new MatrixIndexException("invalid row or column index selection");
        }
        int i = 0;
        while (i < nRows) {
            System.arraycopy(subMatrix[i], 0, this.data[row + i], column, nCols);
            ++i;
        }
        this.lu = null;
    }

    public RealMatrix getRowMatrix(int row) throws MatrixIndexException {
        if (!this.isValidCoordinate(row, 0)) {
            throw new MatrixIndexException("illegal row argument");
        }
        int ncols = this.getColumnDimension();
        double[][] out = new double[1][ncols];
        System.arraycopy(this.data[row], 0, out[0], 0, ncols);
        return new RealMatrixImpl(out);
    }

    public RealMatrix getColumnMatrix(int column) throws MatrixIndexException {
        if (!this.isValidCoordinate(0, column)) {
            throw new MatrixIndexException("illegal column argument");
        }
        int nRows = this.getRowDimension();
        double[][] out = new double[nRows][1];
        int row = 0;
        while (row < nRows) {
            out[row][0] = this.data[row][column];
            ++row;
        }
        return new RealMatrixImpl(out);
    }

    public double[] getRow(int row) throws MatrixIndexException {
        if (!this.isValidCoordinate(row, 0)) {
            throw new MatrixIndexException("illegal row argument");
        }
        int ncols = this.getColumnDimension();
        double[] out = new double[ncols];
        System.arraycopy(this.data[row], 0, out, 0, ncols);
        return out;
    }

    public double[] getColumn(int col) throws MatrixIndexException {
        if (!this.isValidCoordinate(0, col)) {
            throw new MatrixIndexException("illegal column argument");
        }
        int nRows = this.getRowDimension();
        double[] out = new double[nRows];
        int row = 0;
        while (row < nRows) {
            out[row] = this.data[row][col];
            ++row;
        }
        return out;
    }

    public double getEntry(int row, int column) throws MatrixIndexException {
        if (!this.isValidCoordinate(row, column)) {
            throw new MatrixIndexException("matrix entry does not exist");
        }
        return this.data[row][column];
    }

    public RealMatrix transpose() {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        RealMatrixImpl out = new RealMatrixImpl(nCols, nRows);
        double[][] outData = out.getDataRef();
        int row = 0;
        while (row < nRows) {
            int col = 0;
            while (col < nCols) {
                outData[col][row] = this.data[row][col];
                ++col;
            }
            ++row;
        }
        return out;
    }

    public RealMatrix inverse() throws InvalidMatrixException {
        return this.solve(MatrixUtils.createRealIdentityMatrix(this.getRowDimension()));
    }

    public double getDeterminant() throws InvalidMatrixException {
        if (!this.isSquare()) {
            throw new InvalidMatrixException("matrix is not square");
        }
        if (this.isSingular()) {
            return 0.0;
        }
        double det = this.parity;
        int i = 0;
        while (i < this.getRowDimension()) {
            det *= this.lu[i][i];
            ++i;
        }
        return det;
    }

    public boolean isSquare() {
        return this.getColumnDimension() == this.getRowDimension();
    }

    public boolean isSingular() {
        if (this.lu == null) {
            try {
                this.luDecompose();
                return false;
            }
            catch (InvalidMatrixException ex) {
                return true;
            }
        }
        return false;
    }

    public int getRowDimension() {
        return this.data.length;
    }

    public int getColumnDimension() {
        return this.data[0].length;
    }

    public double getTrace() throws IllegalArgumentException {
        if (!this.isSquare()) {
            throw new IllegalArgumentException("matrix is not square");
        }
        double trace = this.data[0][0];
        int i = 1;
        while (i < this.getRowDimension()) {
            trace += this.data[i][i];
            ++i;
        }
        return trace;
    }

    public double[] operate(double[] v) throws IllegalArgumentException {
        if (v.length != this.getColumnDimension()) {
            throw new IllegalArgumentException("vector has wrong length");
        }
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        double[] out = new double[v.length];
        int row = 0;
        while (row < nRows) {
            double sum = 0.0;
            int i = 0;
            while (i < nCols) {
                sum += this.data[row][i] * v[i];
                ++i;
            }
            out[row] = sum;
            ++row;
        }
        return out;
    }

    public double[] preMultiply(double[] v) throws IllegalArgumentException {
        int nRows = this.getRowDimension();
        if (v.length != nRows) {
            throw new IllegalArgumentException("vector has wrong length");
        }
        int nCols = this.getColumnDimension();
        double[] out = new double[nCols];
        int col = 0;
        while (col < nCols) {
            double sum = 0.0;
            int i = 0;
            while (i < nRows) {
                sum += this.data[i][col] * v[i];
                ++i;
            }
            out[col] = sum;
            ++col;
        }
        return out;
    }

    public double[] solve(double[] b) throws IllegalArgumentException, InvalidMatrixException {
        int nRows = this.getRowDimension();
        if (b.length != nRows) {
            throw new IllegalArgumentException("constant vector has wrong length");
        }
        RealMatrixImpl bMatrix = new RealMatrixImpl(b);
        double[][] solution = ((RealMatrixImpl)this.solve(bMatrix)).getDataRef();
        double[] out = new double[nRows];
        int row = 0;
        while (row < nRows) {
            out[row] = solution[row][0];
            ++row;
        }
        return out;
    }

    public RealMatrix solve(RealMatrix b) throws IllegalArgumentException, InvalidMatrixException {
        int j;
        int col;
        if (b.getRowDimension() != this.getRowDimension()) {
            throw new IllegalArgumentException("Incorrect row dimension");
        }
        if (!this.isSquare()) {
            throw new InvalidMatrixException("coefficient matrix is not square");
        }
        if (this.isSingular()) {
            throw new InvalidMatrixException("Matrix is singular.");
        }
        int nCol = this.getColumnDimension();
        int nColB = b.getColumnDimension();
        int nRowB = b.getRowDimension();
        double[][] bp = new double[nRowB][nColB];
        int row = 0;
        while (row < nRowB) {
            col = 0;
            while (col < nColB) {
                bp[row][col] = b.getEntry(this.permutation[row], col);
                ++col;
            }
            ++row;
        }
        col = 0;
        while (col < nCol) {
            int i = col + 1;
            while (i < nCol) {
                j = 0;
                while (j < nColB) {
                    double[] dArray = bp[i];
                    int n = j;
                    dArray[n] = dArray[n] - bp[col][j] * this.lu[i][col];
                    ++j;
                }
                ++i;
            }
            ++col;
        }
        int col2 = nCol - 1;
        while (col2 >= 0) {
            j = 0;
            while (j < nColB) {
                double[] dArray = bp[col2];
                int n = j++;
                dArray[n] = dArray[n] / this.lu[col2][col2];
            }
            int i = 0;
            while (i < col2) {
                int j2 = 0;
                while (j2 < nColB) {
                    double[] dArray = bp[i];
                    int n = j2;
                    dArray[n] = dArray[n] - bp[col2][j2] * this.lu[i][col2];
                    ++j2;
                }
                ++i;
            }
            --col2;
        }
        RealMatrixImpl outMat = new RealMatrixImpl(bp);
        return outMat;
    }

    public void luDecompose() throws InvalidMatrixException {
        int nCols;
        int nRows = this.getRowDimension();
        if (nRows != (nCols = this.getColumnDimension())) {
            throw new InvalidMatrixException("LU decomposition requires that the matrix be square.");
        }
        this.lu = this.getData();
        this.permutation = new int[nRows];
        int row = 0;
        while (row < nRows) {
            this.permutation[row] = row;
            ++row;
        }
        this.parity = 1;
        int col = 0;
        while (col < nCols) {
            double sum = 0.0;
            int row2 = 0;
            while (row2 < col) {
                sum = this.lu[row2][col];
                int i = 0;
                while (i < row2) {
                    sum -= this.lu[row2][i] * this.lu[i][col];
                    ++i;
                }
                this.lu[row2][col] = sum;
                ++row2;
            }
            int max = col;
            double largest = 0.0;
            int row3 = col;
            while (row3 < nRows) {
                sum = this.lu[row3][col];
                int i = 0;
                while (i < col) {
                    sum -= this.lu[row3][i] * this.lu[i][col];
                    ++i;
                }
                this.lu[row3][col] = sum;
                if (Math.abs(sum) > largest) {
                    largest = Math.abs(sum);
                    max = row3;
                }
                ++row3;
            }
            if (Math.abs(this.lu[max][col]) < TOO_SMALL) {
                this.lu = null;
                throw new InvalidMatrixException("matrix is singular");
            }
            if (max != col) {
                double tmp = 0.0;
                int i = 0;
                while (i < nCols) {
                    tmp = this.lu[max][i];
                    this.lu[max][i] = this.lu[col][i];
                    this.lu[col][i] = tmp;
                    ++i;
                }
                int temp = this.permutation[max];
                this.permutation[max] = this.permutation[col];
                this.permutation[col] = temp;
                this.parity = -this.parity;
            }
            int row4 = col + 1;
            while (row4 < nRows) {
                double[] dArray = this.lu[row4];
                int n = col;
                dArray[n] = dArray[n] / this.lu[col][col];
                ++row4;
            }
            ++col;
        }
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("RealMatrixImpl{");
        if (this.data != null) {
            int i = 0;
            while (i < this.data.length) {
                if (i > 0) {
                    res.append(",");
                }
                res.append("{");
                int j = 0;
                while (j < this.data[0].length) {
                    if (j > 0) {
                        res.append(",");
                    }
                    res.append(this.data[i][j]);
                    ++j;
                }
                res.append("}");
                ++i;
            }
        }
        res.append("}");
        return res.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RealMatrixImpl)) {
            return false;
        }
        RealMatrix m = (RealMatrix)object;
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (m.getColumnDimension() != nCols || m.getRowDimension() != nRows) {
            return false;
        }
        int row = 0;
        while (row < nRows) {
            int col = 0;
            while (col < nCols) {
                if (Double.doubleToLongBits(this.data[row][col]) != Double.doubleToLongBits(m.getEntry(row, col))) {
                    return false;
                }
                ++col;
            }
            ++row;
        }
        return true;
    }

    public int hashCode() {
        int ret = 7;
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        ret = ret * 31 + nRows;
        ret = ret * 31 + nCols;
        int row = 0;
        while (row < nRows) {
            int col = 0;
            while (col < nCols) {
                ret = ret * 31 + (11 * (row + 1) + 17 * (col + 1)) * MathUtils.hash(this.data[row][col]);
                ++col;
            }
            ++row;
        }
        return ret;
    }

    protected RealMatrix getIdentity(int dimension) {
        return MatrixUtils.createRealIdentityMatrix(dimension);
    }

    protected RealMatrix getLUMatrix() throws InvalidMatrixException {
        if (this.lu == null) {
            this.luDecompose();
        }
        return new RealMatrixImpl(this.lu);
    }

    protected int[] getPermutation() {
        int[] out = new int[this.permutation.length];
        System.arraycopy(this.permutation, 0, out, 0, this.permutation.length);
        return out;
    }

    private double[][] copyOut() {
        int nRows = this.getRowDimension();
        double[][] out = new double[nRows][this.getColumnDimension()];
        int i = 0;
        while (i < nRows) {
            System.arraycopy(this.data[i], 0, out[i], 0, this.data[i].length);
            ++i;
        }
        return out;
    }

    private void copyIn(double[][] in) {
        this.setSubMatrix(in, 0, 0);
    }

    private boolean isValidCoordinate(int row, int col) {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        return row >= 0 && row <= nRows - 1 && col >= 0 && col <= nCols - 1;
    }
}

