/* Copyright 2007 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest.sample.minesweeper;

import java.util.HashSet;
import java.util.Set;

public class Point {
	private final int x;
	private final int y;
	
	public Point(final int x, final int y) {
		this.x = x;
		this.y = y;
	}
	
	public int getX() {
		return x;
	}
	
	public int getY() {
		return y;
	}
	
	public Set<Point> getAdjacentEight() {
		final Point[] adjacent = {
				new Point(x - 1, y - 1),
				new Point(x + 0, y - 1),
				new Point(x + 1, y - 1),
				new Point(x - 1, y + 0),
//				new Point(x + 0, y + 0), // 自分のセルは除く
				new Point(x + 1, y + 0),
				new Point(x - 1, y + 1),
				new Point(x + 0, y + 1),
				new Point(x + 1, y + 1),
		};
		final Set<Point> set = new HashSet<Point>(8);
		for (final Point item : adjacent) {
			set.add(item);
		}
		return set;
	}

	@Override
	public boolean equals(final Object obj) {
		if (!(obj instanceof Point))
			return false;
		final Point obj2 = (Point)obj;
		return x == obj2.x && y == obj2.y;
	}

	@Override
	public int hashCode() {
		int hash = 0;
		hash = hash * 31 + x;
		hash = hash * 31 + y;
		return hash;
	}
}
