/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/09 13:18:41
 */
package org.asyrinx.joey.gen.command.rdb;

import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.command.Command;
import org.asyrinx.joey.gen.model.rdb.RdbVisitor;
import org.asyrinx.joey.gen.model.rdb.visitor.RdbTopDownVisitor;
import org.asyrinx.joey.gen.model.rdb.visitor.RdbVisitorAdapter;

/**
 * @author takeshi
 */
public class RdbCommandAdapter extends Command {

    /**
     *  
     */
    public RdbCommandAdapter(RdbVisitor adaptee) {
        super();
        this.adaptee = adaptee;
    }

    protected final RdbVisitor adaptee;

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.command.Command#execute(org.asyrinx.joey.gen.model.Element)
     */
    public void execute(Element element) {
        new RdbVisitorAdapter(new RdbTopDownVisitor(this.adaptee)).visit(element);
    }

}