/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/10/27 2:38:38
 */
package org.asyrinx.joey.gen.command.rdb2java.standard;

import java.util.Iterator;

import org.apache.commons.lang.StringUtils;
import org.asyrinx.joey.gen.command.rdb.CopyPackageNames;
import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.java.Entity;
import org.asyrinx.joey.gen.model.java.JavaEnumeration;
import org.asyrinx.joey.gen.model.java.PackageType;
import org.asyrinx.joey.gen.model.rdb.RdbEnumeration;
import org.asyrinx.joey.gen.model.rdb.Table;

/**
 * @author takeshi
 */
public class BasicPackaging implements PackagingStrategy {

    /**
     *  
     */
    public BasicPackaging() {
        super();
    }

    private CopyPackageNames copyPackageNames = new CopyPackageNames();

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.command.rdb2java.standard.PackagingStrategy#toPackageName(org.apache.commons.lang.enum.Enum)
     */
    public String toPackageName(RdbEnumeration enum) {
        return copyPackageNames.toPackageName(enum);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.command.rdb2java.standard.PackagingStrategy#getPackageName(org.asyrinx.joey.gen.model.Element)
     */
    public String getPackageName(Element element) {
        return copyPackageNames.getPackage(element.getOptions());
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.command.rdb2java.standard.PackagingStrategy#toPackageName(org.asyrinx.joey.gen.model.rdb.Table)
     */
    public String toPackageName(Table table) {
        return copyPackageNames.toPackageName(table);
    }

    public static final String PACKAGE_TEMPLATE_SYMBOL = "${packageType}";

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.command.rdb2java.standard.PackagingStrategy#preparePackageNames(org.asyrinx.joey.gen.model.java.Entity)
     */
    public void preparePackageNames(Entity entity) {
        final String template = entity.getPackageTemplate();
        for (Iterator i = PackageType.getElements().iterator(); i.hasNext();) {
            final PackageType packageType = (PackageType) i.next();
            entity.setPackage(packageType.getName(), genPackageName(template, packageType));
        }
    }

    /**
     * @param template
     * @param packageType
     * @return
     */
    private String genPackageName(final String template, final PackageType packageType) {
        final String packageName = StringUtils.replace(template, PACKAGE_TEMPLATE_SYMBOL, packageType.getName());
        return packageName;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.command.rdb2java.standard.PackagingStrategy#preparePackageName(org.asyrinx.joey.gen.model.java.JavaEnumeration)
     */
    public void preparePackageName(JavaEnumeration enum) {
        enum.setPackageName(genPackageName(enum.getPackageName(), PackageType.ENTITY));
    }

}