/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/09 12:51:23
 */
package org.asyrinx.joey.gen.model.command;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.asyrinx.brownie.core.log.DispatchLog;
import org.asyrinx.brownie.core.log.LogLevel;
import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.ElementVisitor;

/**
 * @author takeshi
 */
public class Command implements ElementVisitor {

    private boolean strict = true;

    protected final List errors = new ArrayList();

    protected final DispatchLog log = new DispatchLog(LogFactory.getLog(this.getClass()), "info");

    /**
     *  
     */
    public Command() {
        super();
    }

    protected String element2String(Element element, String msg) {
        if (element != null)
            msg += " @" + element.getFullName();
        msg += " (by command '" + this.getClass().getName() + "')";
        return msg;
    }

    protected void addError(String msg) {
        addError(null, msg);
    }

    protected void addError(Element element, String msg) {
        addError(element, msg, isStrict());
    }

    protected void addError(Element element, String msg, boolean exit) {
        msg = element2String(element, msg);
        if (exit)
            throw new ValidationError(msg, element);
        else
            log.warn(msg);
    }

    protected void log(String msg) {
        log(null, msg);
    }

    protected void log(Element element, String msg) {
        msg = element2String(element, msg);
        log.log(msg);
    }

    /**
     * @return Returns the strict.
     */
    public boolean isStrict() {
        return strict;
    }

    /**
     * @param strict
     *            The strict to set.
     */
    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementVisitor#visit(org.asyrinx.joey.gen.model.Element)
     */
    public void execute(Element element) {
        throw new UnsupportedOperationException("subclass must override");
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementVisitor#visit(org.asyrinx.joey.gen.model.Element)
     */
    public void visit(Element element) {
        throw new UnsupportedOperationException();
    }

}