/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/29 4:06:55
 */
package org.asyrinx.joey.gen.model.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.asyrinx.joey.gen.model.Element;

/**
 * @author akima
 */
public class Entity extends Element implements Type {

    /**
     *  
     */
    public Entity() {
        super();
    }

    /**
     * @param parent
     */
    public Entity(AppDomain parent) {
        super(parent);
    }

    /**
     * @param name
     */
    public Entity(String name) {
        super(name);
    }

    /**
     * @param parent
     * @param name
     */
    public Entity(AppDomain parent, String name) {
        super(parent, name);
    }

    /**
     * @param parent
     * @param name
     * @param label
     */
    public Entity(Element parent, String name, String label) {
        super(parent, name, label);
    }

    private final PropertySet properties = new PropertySet(this);

    private final EntityKeySet keys = new EntityKeySet(this);

    private final ReferenceSet references = new ReferenceSet(this);

    private final Set imports = new HashSet();

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.Element#getParentElement()
     */
    public AppDomain getParent() {
        return (AppDomain) super.getParentElement();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.Type#getFqn()
     */
    public String getFqn() {
        return getPackage() + PACKAGE_SEPARATER + getName();
    }

    public String getPackage() {
        return getPackageName();
    }

    public boolean isPrimitive() {
        return false;
    }

    public Type toClass() {
        return this;
    }

    public Type toPrimitive() {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.Type#getCategory()
     */
    public TypeCategory getCategory() {
        return TypeCategory.OTHERS;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.Type#isNumber()
     */
    public boolean isNumber() {
        return getCategory() == TypeCategory.NUMBER;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.Element#add(org.asyrinx.joey.gen.model.Element)
     */
    public void add(Element element) {
        if (element instanceof Property)
            properties.add((Property) element);
        else if (element instanceof Reference)
            references.add((Reference) element);
        else if (element instanceof EntityKey)
            keys.add((EntityKey) element);
        else
            super.add(element);
    }

    private String packageTemplate = null;

    /**
     * @return Returns the packageName.
     */
    public String getPackageTemplate() {
        return packageTemplate;
    }

    /**
     * @param packageName
     *            The packageName to set.
     */
    public void setPackageTemplate(String packageTemplate) {
        this.packageTemplate = packageTemplate;
    }

    /**
     * @return Returns the packageName.
     */
    public String getPackageName() {
        return getPackage(PackageType.ENTITY.getName());
    }

    /**
     * @param packageName
     *            The packageName to set.
     */
    public void setPackageName(String packageName) {
        setPackage(PackageType.ENTITY.getName(), packageName);
    }

    private final Map packageNames = new HashMap();

    public String getPackage(String packageType) {
        return (String) packageNames.get(packageType);
    }

    public void setPackage(String type, String value) {
        packageNames.put(type, value);
    }

    /**
     * @return Returns the properties.
     */
    public PropertySet getProperties() {
        return properties;
    }

    /**
     * @return Returns the keys.
     */
    public EntityKeySet getKeys() {
        return keys;
    }

    /**
     * @return Returns the references.
     */
    public ReferenceSet getReferences() {
        return references;
    }

    /**
     * @return
     */
    public EntityKey getPrimaryKey() {
        return keys.getPrimaryKey();
    }

    /**
     * @param property
     * @return
     */
    public List getReferencesContainedAsLocal(Property property) {
        return this.getReferences().getReferencesContainedAsLocal(property);
    }

    /**
     * @param javaClass
     * @return
     */
    public List getReferencesContainedAsForeign(Entity javaClass) {
        return this.getReferences().getReferencesContainedAsForeign(javaClass);
    }

    /**
     * @param property
     * @return
     */
    public List getReferencesContainedAsForeign(Property property) {
        return getParent().getReferencesContainedAsForeign(property);
    }

    public List getReferreds() {
        return getParent().getReferencesContainedAsForeign(this);
    }

    /**
     * @param javaClass
     * @param dest
     */
    public void findReferencesContainedAsForeign(Entity javaClass, List dest) {
        getReferences().findReferencesContainedAsForeign(javaClass, dest);
    }

    /**
     * @param javaClass
     * @param result
     */
    public void findReferencesContainedAsLocal(Entity javaClass, List dest) {
        getReferences().findReferencesContainedAsLocal(javaClass, dest);
    }

    /**
     * @return Returns the imports.
     */
    public Set getImports() {
        return imports;
    }

    private String superClassName = null;

    private Entity superClass = null;

    /**
     * @return Returns the superClass.
     */
    public Entity getSuperClass() {
        return superClass;
    }

    /**
     * @param superClass
     *            The superClass to set.
     */
    public void setSuperClass(Entity superClass) {
        this.superClass = superClass;
    }

    /**
     * @return Returns the superClassName.
     */
    public String getSuperClassName() {
        return superClassName;
    }

    /**
     * @param superClassName
     *            The superClassName to set.
     */
    public void setSuperClassName(String superClassName) {
        this.superClassName = superClassName;
    }

    public List getPropertiesExtended() {
        if (this.getSuperClass() == null)
            return new ArrayList();
        final List result = new ArrayList(this.getSuperClass().getPropertiesExtended());
        result.addAll(this.getSuperClass().getProperties().toList());
        return result;
    }

    public List getPropertiesAll() {
        final List result = getPropertiesExtended();
        result.addAll(this.getProperties().toList());
        return result;
    }

}