/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/27
 */
package org.asyrinx.joey.gen.model.java;

import org.asyrinx.joey.gen.model.AbstractEnumeration;

/**
 * @author akima
 */
public class JavaEnumeration extends AbstractEnumeration implements Type {

    private String packageName = null;

    private Type valueTypeObj = null;

    /**
     *  
     */
    public JavaEnumeration() {
        super();
    }

    /**
     * @param parent
     * @param name
     */
    public JavaEnumeration(AppDomain parent, String name) {
        super(parent, name);
    }

    /**
     * @param parent
     * @param name
     * @param type
     */
    public JavaEnumeration(AppDomain parent, String name, String type) {
        super(parent, name, type);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.Element#getParentElement()
     */
    public AppDomain getParent() {
        return (AppDomain) super.getParentElement();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.Type#getFqn()
     */
    public String getFqn() {
        return getPackage() + PACKAGE_SEPARATER + getName();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.Type#getPackage()
     */
    public String getPackage() {
        return getPackageName();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.Type#isPrimitive()
     */
    public boolean isPrimitive() {
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.Type#toClass()
     */
    public Type toClass() {
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.Type#toPrimitive()
     */
    public Type toPrimitive() {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.Type#getCategory()
     */
    public TypeCategory getCategory() {
        return TypeCategory.OTHERS;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.Type#isNumber()
     */
    public boolean isNumber() {
        return false;
    }

    /**
     * @return Returns the packageName.
     */
    public String getPackageName() {
        return packageName;
    }

    /**
     * @param packageName
     *            The packageName to set.
     */
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    /**
     * @return Returns the valueTypeObj.
     */
    public Type getValueTypeObj() {
        return valueTypeObj;
    }

    /**
     * @param valueTypeObj
     *            The valueTypeObj to set.
     */
    public void setValueTypeObj(Type valueTypeObj) {
        this.valueTypeObj = valueTypeObj;
    }
}