/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/14 18:07:57
 */
package org.asyrinx.joey.gen.model.java;

import java.util.List;

import org.apache.commons.lang.StringUtils;

/**
 * @author akima
 */
public class Property extends EntityElement {

    private String typeName = null;

    private Type type = null;

    private String defaultValue = null;

    private int maxLength = 0;

    private boolean required = false;

    private String enumPropertyName = null;

    private JavaEnumeration enumType = null;

    private boolean primaryKey = false;

    private boolean extended = false;

    /**
     *  
     */
    public Property() {
        super();
    }

    /**
     * @param parent
     */
    public Property(Entity parent) {
        super(parent);
    }

    /**
     * @return Returns the defaultValue.
     */
    public String getDefaultValue() {
        return defaultValue;
    }

    /**
     * @return Returns the defaultValue.
     */
    public String getDefaultValue4Velocity() {
        return (defaultValue == null) ? "null" : defaultValue;
    }

    /**
     * @param defaultValue
     *            The defaultValue to set.
     */
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    /**
     * @return Returns the typeName.
     */
    public String getTypeName() {
        return typeName;
    }

    /**
     * @param typeName
     *            The typeName to set.
     */
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    /**
     * @return Returns the maxLength.
     */
    public int getMaxLength() {
        return maxLength;
    }

    /**
     * @param maxLength
     *            The maxLength to set.
     */
    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    /**
     * @return Returns the type.
     */
    public Type getType() {
        return type;
    }

    /**
     * @param type
     *            The type to set.
     */
    public void setType(Type javaType) {
        this.type = javaType;
        if ((this.type != null) && StringUtils.isEmpty(getTypeName())) {
            setTypeName(this.type.getName());
        }
    }

    /**
     * @return Returns the required.
     */
    public boolean isRequired() {
        return required;
    }

    /**
     * @param required
     *            The required to set.
     */
    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getCapitalizedName() {
        return StringUtils.capitalize(this.getName());
    }

    /**
     * @return
     */
    public List getReferencesContainedAsLocal() {
        return getParent().getReferencesContainedAsLocal(this);
    }

    /**
     * @return
     */
    public List getReferencesContainedAsForeign() {
        return getParent().getReferencesContainedAsForeign(this);
    }

    public boolean isInForeignKey() {
        return (getReferencesContainedAsLocal().size() > 0) || (getReferencesContainedAsForeign().size() > 0);
    }

    /**
     * @return Returns the enumPropertyName.
     */
    public String getEnumPropertyName() {
        return enumPropertyName;
    }

    /**
     * @param enumPropertyName
     *            The enumPropertyName to set.
     */
    public void setEnumPropertyName(String enumPropertyName) {
        this.enumPropertyName = enumPropertyName;
    }

    /**
     * @return Returns the enumType.
     */
    public JavaEnumeration getEnumType() {
        return enumType;
    }

    /**
     * @param enumType
     *            The enumType to set.
     */
    public void setEnumType(JavaEnumeration enumType) {
        this.enumType = enumType;
    }

    public boolean isPrimaryKey() {
        return primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean isSinglePrimaryKey() {
        if (!isPrimaryKey())
            return false;
        return this.getParent().getPrimaryKey().size() == 1;
    }

    public boolean isExtended() {
        return extended;
    }

    public void setExtended(boolean extended) {
        this.extended = extended;
    }
}