/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/08 11:25:21
 */
package org.asyrinx.joey.gen.model.java;

import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.asyrinx.joey.gen.model.ElementSet;

/**
 * @author takeshi
 */
public class Reference extends ElementSet {

    public static final String HIBERNATE_DIRECTION = "hibernateDirection";

    /** optionsɒǉhibernateDirection̒l */
    public static final String DIRECTION_NONE = "none";

    /** optionsɒǉhibernateDirection̒l */
    public static final String DIRECTION_FORWARD = "forward";

    /** optionsɒǉhibernateDirection̒l */
    public static final String DIRECTION_BACKWARD = "backward";

    /** optionsɒǉhibernateDirection̒l */
    public static final String DIRECTION_BIDIRECTIONAL = "bidirectional";

    /**
     * @param parent
     */
    public Reference(Entity parent) {
        super(parent);
    }

    /**
     * @param parent
     * @param name
     */
    public Reference(Entity parent, String name) {
        super(parent, name);
    }

    private Entity referenceClass = null;

    private ReferenceType type = ReferenceType.NORMAL;

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#isEntity()
     */
    public boolean isEntity() {
        return true;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.Element#getParentElement()
     */
    public Entity getParent() {
        return (Entity) super.getParentElement();
    }

    public void add(ReferenceEntry entry) {
        super.add(entry);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#contains(org.asyrinx.joey.gen.model.Element)
     */
    public boolean contains(ReferenceEntry entry) {
        return super.contains(entry);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#getElement(int)
     */
    public ReferenceEntry getEntry(int index) {
        return (ReferenceEntry) super.getElement(index);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#get(java.lang.String)
     */
    public ReferenceEntry getEntry(String name) {
        return (ReferenceEntry) super.getElement(name);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#remove(java.lang.String)
     */
    public ReferenceEntry removeEntry(String name) {
        return (ReferenceEntry) super.removeElement(name);
    }

    /**
     * @return
     */
    public String getReferenceClassName() {
        return (getReferenceClass() == null) ? null : getReferenceClass().getName();
    }

    /**
     * @return Returns the referenceClass.
     */
    public Entity getReferenceClass() {
        return referenceClass;
    }

    /**
     * @param referenceClass
     *            The referenceClass to set.
     */
    public void setReferenceClass(Entity referenceClass) {
        this.referenceClass = referenceClass;
    }

    /**
     * @param property
     * @return
     */
    public boolean containsAsLocal(Property property) {
        for (Iterator i = this.iterator(); i.hasNext();) {
            final ReferenceEntry entry = (ReferenceEntry) i.next();
            if (entry.getLocal() == property)
                return true;
        }
        return false;
    }

    /**
     * @param property
     * @return
     */
    public boolean containsAsForeign(Property property) {
        for (Iterator i = this.iterator(); i.hasNext();) {
            final ReferenceEntry entry = (ReferenceEntry) i.next();
            if (entry.getForeign() == property)
                return true;
        }
        return false;
    }

    public String getPropertyNameInReferred(boolean plural) {
        //	#foreach ($fk in $table.Referrers)
        //	  #set ( $tblFK = $fk.Table )
        //	  #if ( !($tblFK.Name.equals($table.Name)) )
        //	  #set ( $className = $tblFK.JavaName )
        //	  #set ( $relatedByCol = "" )
        final String className = getParent().getName();
        String relatedByCol = "";
        final List otherRefs = this.getParent().getParent().getReferencesContainedAsLocal(getParent());
        if (otherRefs.size() > 1) {
            //	  #foreach ($columnName in $fk.LocalColumns)
            //		#set ( $column = $tblFK.getColumn($columnName) )
            //		#if ($column.isMultipleFK())
            //		  #set ($relatedByCol= "$relatedByCol$column.JavaName")
            //		#end
            //	  #end
            for (Iterator i = this.iterator(); i.hasNext();) {
                final ReferenceEntry entry = (ReferenceEntry) i.next();
                if (!entry.getLocal().getReferencesContainedAsLocal().isEmpty())
                    relatedByCol = relatedByCol + entry.getLocal().getCapitalizedName();
            }
        }
        //	#if ($relatedByCol == "")
        //	  #set ( $suffix = "" )
        //	  #set ( $relCol = "${className}s" )
        //	  #set ( $relColMs = $className )
        //	#else
        //	  #set ( $suffix = "RelatedBy$relatedByCol" )
        //	  #set ( $relCol= "${className}sRelatedBy$relatedByCol" )
        //	  #set ( $relColMs= "${className}RelatedBy$relatedByCol" )
        //	#end
        if (StringUtils.isEmpty(relatedByCol)) {
            return (plural) ? StringUtils.uncapitalize(className + "s") : StringUtils.uncapitalize(className);
        }
        return (plural) ? StringUtils.uncapitalize(className + "sRelatedBy" + relatedByCol) : StringUtils
                .uncapitalize(className + "RelatedBy" + relatedByCol);
    }

    public String getPropertyNameInReferred() {
        return getPropertyNameInReferred(true);
    }

    public String getPropertyNameInLocal() {
        //#foreach ($fk in $table.ForeignKeys)
        //
        //  #set ( $tblFK = $table.Database.getTable($fk.ForeignTableName) )
        //  #set ( $className = $tblFK.JavaName )
        //  #set ( $relCol = "" )
        final Entity foreignClass = this.getReferenceClass();
        final String className = foreignClass.getName();
        String relCol = "";

        final List otherRefs = this.getParent().getReferencesContainedAsForeign(foreignClass);
        if (otherRefs.size() > 1) {
            //  #foreach ($columnName in $fk.LocalColumns)
            //	#set ( $column = $table.getColumn($columnName) )
            //	#if ($column.isMultipleFK() ||
            // $fk.ForeignTableName.equals($table.Name))
            //	  #set ( $relCol = "$relCol$column.JavaName" )
            //	#end
            //  #end
            for (Iterator i = this.iterator(); i.hasNext();) {
                final ReferenceEntry entry = (ReferenceEntry) i.next();
                if ((!entry.getLocal().getReferencesContainedAsLocal().isEmpty())
                        || (getReferenceClass() == this.getParent()))
                    relCol = relCol + entry.getLocal().getCapitalizedName();
            }
        }

        //  #if ($relCol != "")
        //	#set ( $relCol = "RelatedBy$relCol" )
        //  #end
        if (StringUtils.isNotEmpty(relCol))
            relCol = "RelatedBy" + relCol;

        //  #set ( $pVarName = "$className$relCol" )
        return StringUtils.uncapitalize(className + relCol);
    }

    /**
     * @return Returns the type.
     */
    public ReferenceType getType() {
        return type;
    }

    /**
     * @param type
     *            The type to set.
     */
    public void setType(ReferenceType type) {
        this.type = type;
    }

    public String getHibernateDirection() {
        return String.valueOf(this.getOption(HIBERNATE_DIRECTION));
    }

    public boolean isHibernateForward() {
        return DIRECTION_FORWARD.equals(getHibernateDirection())
                || DIRECTION_BIDIRECTIONAL.equals(getHibernateDirection());
    }

    public boolean isHibernateBackward() {
        return DIRECTION_BACKWARD.equals(getHibernateDirection())
                || DIRECTION_BIDIRECTIONAL.equals(getHibernateDirection());
    }
}