/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/10/27 5:31:55
 */
package org.asyrinx.joey.gen.model.java.classes;

import java.util.HashMap;
import java.util.Map;

import org.asyrinx.joey.gen.model.java.Type;
import org.asyrinx.joey.gen.model.java.TypeCategory;

/**
 * @author takeshi
 */
public abstract class EmbeddedClass implements Type {

    private static final Map nameToType = new HashMap();

    public static EmbeddedClass get(String name) {
        return (EmbeddedClass) nameToType.get(name);
    }

    /**
     *  
     */
    public EmbeddedClass(String packageName, String className, TypeCategory category) {
        this(packageName, className, category, false);
    }

    /**
     *  
     */
    public EmbeddedClass(String packageName, String className, TypeCategory category, boolean meaningNumber) {
        super();
        this.packageName = packageName;
        this.className = className;
        this.category = category;
        nameToType.put(className, this);
    }

    private final String packageName;

    private final String className;

    private final TypeCategory category;

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.Type#getCategory()
     */
    public TypeCategory getCategory() {
        return this.category;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.Type#getFqn()
     */
    public String getFqn() {
        return getPackage() + PACKAGE_SEPARATER + getName();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.Type#getPackage()
     */
    public String getPackage() {
        return getPackageName();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.Type#getName()
     */
    public String getName() {
        return this.className;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.Type#isPrimitive()
     */
    public boolean isPrimitive() {
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.Type#toClass()
     */
    public Type toClass() {
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.Type#toPrimitive()
     */
    public Type toPrimitive() {
        return null;
    }

    /**
     * @return Returns the className.
     */
    public String getClassName() {
        return className;
    }

    /**
     * @return Returns the packageName.
     */
    public String getPackageName() {
        return packageName;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.Type#isNumber()
     */
    public boolean isNumber() {
        return getCategory() == TypeCategory.NUMBER;
    }

}