/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/10 16:59:32
 */
package org.asyrinx.joey.gen.model.rdb;

import java.util.Iterator;

import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.joey.gen.model.Element;

import test.org.asyrinx.joey.gen.model.rdb.Constants;

/**
 * @author akima
 */
public class Database extends Element {

    public Database() {
        super();
    }

    /**
     *  
     */
    public Database(Databases parent, String name) {
        super(parent, name);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.Element#getParentElement()
     */
    public Databases getParent() {
        return (Databases) super.getParentElement();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.Element#add(org.asyrinx.joey.gen.model.Element)
     */
    public void add(Element element) {
        if (element instanceof Table)
            tables.add((Table) element);
        else if (element instanceof RdbEnumeration)
            enumerations.add((RdbEnumeration) element);
        else
            super.add(element);
    }

    private final TableSet tables = new TableSet(this);

    /**
     * @return Returns the tables.
     */
    public TableSet getTables() {
        return tables;
    }

    private final RdbEnumerationSet enumerations = new RdbEnumerationSet(this);

    /**
     * @return Returns the enumerations.
     */
    public RdbEnumerationSet getEnumerations() {
        return enumerations;
    }

    /**
     * @param committed
     */
    public void moveTables(Database dest) {
        for (final Iterator i = tables.iterator(); i.hasNext();) {
            final Table table = (Table) i.next();
            dest.getTables().add(table);
        }
    }

    /**
     * @param committed
     */
    public void moveEnumerations(Database dest) {
        for (final Iterator i = enumerations.iterator(); i.hasNext();) {
            final RdbEnumeration enumeration = (RdbEnumeration) i.next();
            dest.getEnumerations().add(enumeration);
        }
    }

    /**
     * @param string
     * @return
     */
    public Column getColumn(String columnName) {
        final String[] nameParts = StringUtils.tokenizeToArray(columnName, Constants.ELEMENTS_DELIMITER);
        if (nameParts.length == 2) {
            return getColumn(nameParts[0], nameParts[1]);
        } else if (nameParts.length == 3) {
            if (getParent() != null)
                return getParent().getColumn(columnName);
        }
        return null;
    }

    public Column getColumn(String tableName, String columnName) {
        final Table table = getTables().getTable(tableName);
        return (table == null) ? null : table.getColumns().getColumn(columnName);

    }
}