/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/16 14:24:25
 */
package org.asyrinx.joey.gen.model.rdb.xml;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.logging.LogFactory;
import org.asyrinx.brownie.core.xml.digester.AsyrinxDigester;
import org.asyrinx.joey.gen.model.EnumerationEntry;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.asyrinx.joey.gen.model.rdb.RdbEnumeration;
import org.asyrinx.joey.gen.model.rdb.ForeignKey;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyEntry;
import org.asyrinx.joey.gen.model.rdb.Index;
import org.asyrinx.joey.gen.model.rdb.IndexEntry;
import org.asyrinx.joey.gen.model.rdb.Table;
import org.asyrinx.joey.gen.model.rdb.Unique;
import org.xml.sax.SAXException;

/**
 * @author akima
 */
public class XmlToRdb {

    /**
     *  
     */
    public XmlToRdb() {
        super();
    }

    private boolean debug = false;

    public Databases load(String filename) throws IOException, SAXException {
        final FileInputStream inputStream = new FileInputStream(filename);
        return load(inputStream);
    }

    public Databases load(InputStream sourceStream) throws IOException, SAXException {
        final AsyrinxDigester d = new AsyrinxDigester();
        d.setValidating(false);
        if (isDebug()) {
            d.setLogger(LogFactory.getLog(this.getClass()));
        }

        d.addBodyToProp("*/description", "description");

        d.addRoot("databases", Databases.class);
        d.addProps("databases/database", Database.class);
        d.addSetProperties("database");

        d.addProps("*/database/enum", RdbEnumeration.class);
        d.addProps("*/database/enum/enum-entry", EnumerationEntry.class);

        //WmTable
        d.addProps("*/database/table", Table.class);

        //d.addProps("*/column/id-method-parameter", WmIdMethodParameter.class,
        // "addIdMethodParameter");

        d.addProps("*/column", Column.class);
        //d.addProps("*/column/inheritance", WmInheritance.class,
        // "addInheritance");
        //d.addProps("*/column/property", WmProperty.class, "addProperty");
        //d.addProps("*/property/format", WmColumnFormat.class, "setFormat");
        //d.addProps("*/column/format", WmColumnFormat.class, "setFormat");

        d.addProps("*/foreign-key", ForeignKey.class);
        d.addProps("*/foreign-key/reference", ForeignKeyEntry.class);

        d.addProps("*/index", Index.class);
        d.addProps("*/index/index-column", IndexEntry.class);

        d.addProps("*/unique", Unique.class);
        d.addProps("*/unique/unique-column", IndexEntry.class);

        final Object result = d.parse(sourceStream);
        return (Databases) result;
    }

    /**
     * @return Returns the debug.
     */
    public boolean isDebug() {
        return debug;
    }

    /**
     * @param debug
     *               The debug to set.
     */
    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}