/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/08 15:00:36
 */
package test.org.asyrinx.joey.gen.command.rdb;

import junit.framework.TestCase;

import org.asyrinx.joey.gen.command.rdb.StandardCommands;
import org.asyrinx.joey.gen.model.command.Command;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.asyrinx.joey.gen.model.rdb.Table;

/**
 * @author takeshi
 */
public class StandardCommandsTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(StandardCommandsTest.class);
    }

    public void testExecute() {
        final Databases databases = new Databases();
        final Database db1 = new Database(databases, "db1");
        db1.getOptions().put("javaPackage", "org.asyrinx.joey.sample");
        //
        final Table t_party = new Table(db1, "party", "p[eB");
        final Column c_party_party_id = new Column(t_party, "party_id", "BIGINT", "0", true, true, "0");
        new Column(t_party, "name", "VARCHAR", "20", true, false, null);
        //
        final Table t_role = new Table(db1, "role", "[");
        final Column c_role_role_id = new Column(t_role, "role_id", "BIGINT", "0", true, true, "0");
        final Column colPartyId = new Column(t_role, "party_id", "BIGINT", "0", true, false, "0");
        colPartyId.setFk("party.party_id");
        //
        final Table t_user = new Table(db1, "system_user", "VXe[U");
        t_user.setExtends("role");
        final Column c_user_system_user_id = new Column(t_user, "system_user_id", "BIGINT", "0", true, true, "0");
        new Column(t_user, "values", "VARCHAR", "20", true, false, null);
        //
        final Command command = new StandardCommands();
        command.execute(databases);
        //
        assertEquals(2, t_party.getColumns().size());
        assertEquals(1, t_party.getPrimaryKey().size());
        assertEquals(c_party_party_id, t_party.getPrimaryKey().getEntry(0).getColumn());
        //
        assertEquals(2, t_role.getColumns().size());
        assertEquals(1, t_role.getPrimaryKey().size());
        assertEquals(c_role_role_id, t_role.getPrimaryKey().getEntry(0).getColumn());
        //
        assertEquals(3, t_user.getColumns().size());
        assertEquals(1, t_user.getPrimaryKey().size());
        assertEquals(c_user_system_user_id, t_user.getPrimaryKey().getEntry(0).getColumn());
    }

}