/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/16 17:59:04
 */
package test.org.asyrinx.joey.gen.model.rdb.xml;

import java.io.IOException;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.io.sf.StreamFactory;
import org.asyrinx.brownie.core.io.sf.StreamFactoryFacade;
import org.asyrinx.brownie.core.lang.NumberUtils;
import org.asyrinx.joey.gen.command.rdb.StandardCommands;
import org.asyrinx.joey.gen.model.EnumerationEntry;
import org.asyrinx.joey.gen.model.command.ValidationError;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.asyrinx.joey.gen.model.rdb.RdbEnumeration;
import org.asyrinx.joey.gen.model.rdb.ForeignKey;
import org.asyrinx.joey.gen.model.rdb.ForeignKeyEntry;
import org.asyrinx.joey.gen.model.rdb.Index;
import org.asyrinx.joey.gen.model.rdb.IndexEntry;
import org.asyrinx.joey.gen.model.rdb.Table;
import org.asyrinx.joey.gen.model.rdb.Unique;
import org.asyrinx.joey.gen.model.rdb.xml.XmlToRdb;
import org.xml.sax.SAXException;

/**
 * @author akima
 */
public class XmlToRdbTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(XmlToRdbTest.class);
    }

    /*
     * Class under test for Database load(InputStream)
     */
    public void testLoadInputStream() {
        final StreamFactory sf = StreamFactoryFacade.newFacade().addRelativeClassResourceSF();
        Databases databases;
        try {
            final XmlToRdb xmlToRdb = new XmlToRdb();
            xmlToRdb.setDebug(true);
            databases = xmlToRdb.load(sf.newInput("chiffon-schema.xml"));
        } catch (IOException e) {
            e.printStackTrace();
            fail();
            return;
        } catch (SAXException e) {
            e.printStackTrace();
            fail();
            return;
        }
        try {
            new StandardCommands().execute(databases);
        } catch (ValidationError e) {
            e.printStackTrace();
            fail();
            return;
        }
        assertEquals(1, databases.getDatabases().size());
        final Database database = databases.getDatabases().getDatabase(0);
        //
        assertEquals("sample1", database.getName());
        assertEquals(3, database.getTables().size());
        final Table table1 = database.getTables().getTable(0);
        assertEquals("party", table1.getName());
        assertEquals("p[eB", table1.getLabel());
        assertEquals("p[eB̓O[vElȂǂ\܂B ڂMartin FowleŕuAiVXp^[vQƂĂB", table1.getDescription());
        assertEquals(2, table1.getColumns().size());
        final Column column1_1 = table1.getColumns().getColumn(0);
        final Column column1_2 = table1.getColumns().getColumn(1);
        checkColumn(column1_1, "party_id", "ID", "BIGINT", 0, true, true);
        checkColumn(column1_2, "name", "", "VARCHAR", 50, true, false);
        //assertEquals(1, table1.getIndexes().size());
        //final Index index1_1 = table1.getIndexes().getIndex(0);
        //assertEquals("i_party_name", index1_1.getName());
        //assertEquals(1, index1_1.size());
        //final IndexEntry entry1_1_1 = index1_1.getEntry(0);
        //assertEquals("name", entry1_1_1.getName());
        //assertEquals(column1_2, entry1_1_1.getColumn());
        //
        assertEquals(1, database.getEnumerations().size());
        final RdbEnumeration enumeration = database.getEnumerations().getEnumeration(0);
        assertEquals(3, enumeration.size());
        final EnumerationEntry enumEntry1 = enumeration.getEntry(0);
        final EnumerationEntry enumEntry2 = enumeration.getEntry(1);
        final EnumerationEntry enumEntry3 = enumeration.getEntry(2);
        assertEquals(1, NumberUtils.toInt(enumEntry1.getValue(), 0));
        assertEquals(2, NumberUtils.toInt(enumEntry2.getValue(), 0));
        assertEquals(3, NumberUtils.toInt(enumEntry3.getValue(), 0));
        assertEquals("viewer", enumEntry1.getName());
        assertEquals("editor", enumEntry2.getName());
        assertEquals("admin", enumEntry3.getName());
        //
        final Table table2 = database.getTables().getTable(1);
        assertEquals("member", table2.getName());
        assertEquals("o[", table2.getLabel());
        assertEquals(5, table2.getColumns().size());
        final Column column2_1 = table2.getColumns().getColumn(0);
        final Column column2_2 = table2.getColumns().getColumn(1);
        final Column column2_3 = table2.getColumns().getColumn(2);
        final Column column2_4 = table2.getColumns().getColumn(3);
        final Column column2_5 = table2.getColumns().getColumn(4);
        checkColumn(column2_1, "member_id", null, "BIGINT", 0, true, true);
        checkColumn(column2_2, "member_type_id", null, "INTEGER", 0, true, false);
        checkColumn(column2_3, "party_id", null, "BIGINT", 0, true, false);
        checkColumn(column2_4, "login_name", null, "VARCHAR", 20, true, false);
        checkColumn(column2_5, "password", null, "VARCHAR", 20, false, false);
        assertEquals("MemberType", column2_2.getEnum());
        assertEquals(enumeration, column2_2.getEnumeration());
        //
        assertEquals(1, table2.getForeignKeys().size());
        final ForeignKey fk2_1 = table2.getForeignKeys().getForeignKey(0);
        assertEquals("f_member_party", fk2_1.getName());
        assertEquals("party", fk2_1.getForeign());
        assertEquals(table1, fk2_1.getForeignTable());
        assertEquals(1, fk2_1.size());
        final ForeignKeyEntry fkEntry2_1_1 = fk2_1.getEntry(0);
        assertEquals("party_id", fkEntry2_1_1.getLocal());
        assertEquals("party_id", fkEntry2_1_1.getForeign());
        assertEquals(column2_3, fkEntry2_1_1.getLocalColumn());
        assertEquals(column1_1, fkEntry2_1_1.getForeignColumn());
        //
        assertEquals(1, table2.getUniques().size());
        final Unique unique = (Unique) table2.getUniques().getIndex(0);
        assertEquals("u_member_login_name", unique.getName());
        assertEquals(1, unique.size());
        final IndexEntry entry = unique.getEntry(0);
        assertEquals("login_name", entry.getName());
        assertEquals(column2_4, entry.getColumn());
        //
        final Table table3 = database.getTables().getTable(2);
        assertEquals("special_member", table3.getName());
        assertEquals("ꃁo[", table3.getLabel());
        assertEquals(3, table3.getColumns().size());
        final Column column3_1 = table3.getColumns().getColumn(0);
        final Column column3_2 = table3.getColumns().getColumn(1);
        final Column column3_3 = table3.getColumns().getColumn(2);
        checkColumn(column3_1, "special_member_id", null, "BIGINT", 0, true, true);
        checkColumn(column3_2, "nickname", null, "VARCHAR", 10, true, false);
        checkColumn(column3_3, "member_id", null, "BIGINT", 0, true, false);
        //
        assertEquals(1, table3.getForeignKeys().size());
        final ForeignKey fk3_1 = table3.getForeignKeys().getForeignKey(0);
        assertEquals("f_special_member_1", fk3_1.getName());
        assertEquals("member", fk3_1.getForeign());
        assertEquals(table2, fk3_1.getForeignTable());
        assertEquals(1, fk2_1.size());
    }

    private void checkColumn(Column col, String name, String label, String type, int size, boolean required,
            boolean primaryKey) {
        assertEquals(name, col.getName());
        assertEquals(label, col.getLabel());
        assertEquals(type, col.getType());
        assertEquals(size, col.getSizeAsInt());
        assertEquals(required, col.isRequired());
        assertEquals(primaryKey, col.isPrimaryKey());
    }

}