/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/09 13:07:41
 */
package org.asyrinx.joey.gen.command.java;

import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.command.Command;
import org.asyrinx.joey.gen.model.java.AppDomain;
import org.asyrinx.joey.gen.model.java.Entity;
import org.asyrinx.joey.gen.model.java.EntityKey;
import org.asyrinx.joey.gen.model.java.JavaEnumeration;
import org.asyrinx.joey.gen.model.java.JavaVisitor;
import org.asyrinx.joey.gen.model.java.Property;
import org.asyrinx.joey.gen.model.java.Reference;
import org.asyrinx.joey.gen.model.java.visitor.JavaTopDownVisitor;
import org.asyrinx.joey.gen.model.java.visitor.JavaVisitorAdapter;

/**
 * @author takeshi
 */
public class JavaCommand extends Command implements JavaVisitor {

    /**
     *  
     */
    public JavaCommand() {
        super();
    }

    public void execute(Element element) {
        new JavaVisitorAdapter(new JavaTopDownVisitor(this)).visit(element);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.JavaVisitor#visit(org.asyrinx.joey.gen.model.java.AppDomain)
     */
    public void visit(AppDomain appDomain) {
        //may be overriden by subclass
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.JavaVisitor#visit(org.asyrinx.joey.gen.model.java.Entity)
     */
    public void visit(Entity javaClass) {
        //may be overriden by subclass
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.JavaVisitor#visit(org.asyrinx.joey.gen.model.java.EntityKey)
     */
    public void visit(EntityKey entity) {
        //may be overriden by subclass
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.JavaVisitor#visit(org.asyrinx.joey.gen.model.java.JavaEnumeration)
     */
    public void visit(JavaEnumeration enum) {
        //may be overriden by subclass
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.JavaVisitor#visit(org.asyrinx.joey.gen.model.java.Property)
     */
    public void visit(Property property) {
        //may be overriden by subclass
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.java.JavaVisitor#visit(org.asyrinx.joey.gen.model.java.Reference)
     */
    public void visit(Reference reference) {
        //may be overriden by subclass
    }

}