/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/15 18:29:32
 */
package org.asyrinx.joey.gen.command.rdb;

import org.apache.commons.lang.StringUtils;
import org.asyrinx.joey.gen.model.rdb.ForeignKey;
import org.asyrinx.joey.gen.model.rdb.Index;
import org.asyrinx.joey.gen.model.rdb.Table;

/**
 * @author akima
 */
public class BasicNaming extends RdbCommand {

    /**
     *  
     */
    public BasicNaming() {
        super();
    }

    private String separater = "_";

    private String fkHeader = "f";

    private String indexHeader = "i";

    /**
     * @return Returns the fkHeader.
     */
    public String getFkHeader() {
        return fkHeader;
    }

    /**
     * @param fkHeader
     *               The fkHeader to set.
     */
    public void setFkHeader(String fkIndexHeader) {
        this.fkHeader = fkIndexHeader;
    }

    /**
     * @return Returns the indexHeader.
     */
    public String getIndexHeader() {
        return indexHeader;
    }

    /**
     * @param indexHeader
     *               The indexHeader to set.
     */
    public void setIndexHeader(String indexHeader) {
        this.indexHeader = indexHeader;
    }

    /**
     * @return Returns the separater.
     */
    public String getSeparater() {
        return separater;
    }

    /**
     * @param separater
     *               The separater to set.
     */
    public void setSeparater(String separater) {
        this.separater = separater;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.RdbVisitor#visit(org.asyrinx.joey.gen.model.rdb.ForeignKey)
     */
    public void visit(ForeignKey foreignKey) {
        if (foreignKey == null)
            return;
        if (!StringUtils.isEmpty(foreignKey.getName()))
            return;
        final Table table = foreignKey.getParent();
        if (table == null)
            errors.add("foreignKey has no parent table.");
        final int index = table.getForeignKeys().indexOf(foreignKey) + 1;
        final String name = getFkHeader() + getSeparater() + table.getName() + getSeparater() + index;
        foreignKey.setName(name);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.rdb.RdbVisitor#visit(org.asyrinx.joey.gen.model.rdb.Index)
     */
    public void visit(Index index) {
        if (index == null)
            return;
        if (!StringUtils.isEmpty(index.getName()))
            return;
        final Table table = index.getParent();
        if (table == null)
            errors.add("index has no parent table.");
        final ForeignKey foreignKey = table.findForeignKey(index);
        final String name;
        if (foreignKey != null) {
            if (StringUtils.isEmpty(foreignKey.getName()))
                this.visit(foreignKey);
            name = getIndexHeader() + getSeparater() + foreignKey.getName();
        } else {
            final int idx = table.getIndexes().indexOf(index) + 1;
            name = getIndexHeader() + getSeparater() + table.getName() + getSeparater() + idx;
        }
        index.setName(name);
    }

}