/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/16 6:04:53
 */
package org.asyrinx.joey.gen.model.command;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.asyrinx.joey.gen.model.Element;

/**
 * @author akima
 */
public class CompositeCommand extends Command {

    /**
     *  
     */
    public CompositeCommand() {
        super();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.command.rdb.RdbCommand#execute(org.asyrinx.joey.gen.model.Element)
     */
    public void execute(Element element) {
        for (Iterator i = this.iterator(); i.hasNext();) {
            final Command command = (Command) i.next();
            command.execute(element);
        }
    }

    private final List commands = new ArrayList();

    /**
     * @param o
     * @return
     */
    public boolean add(Command o) {
        return commands.add(o);
    }

    /**
     *  
     */
    public void clear() {
        commands.clear();
    }

    /**
     * @param o
     * @return
     */
    public boolean contains(Command o) {
        return commands.contains(o);
    }

    /**
     * @param index
     * @return
     */
    public Command get(int index) {
        return (Command) commands.get(index);
    }

    /**
     * @param o
     * @return
     */
    public int indexOf(Command o) {
        return commands.indexOf(o);
    }

    /**
     * @return
     */
    public boolean isEmpty() {
        return commands.isEmpty();
    }

    /**
     * @return
     */
    public Iterator iterator() {
        return commands.iterator();
    }

    /**
     * @param o
     * @return
     */
    public boolean remove(Command o) {
        return commands.remove(o);
    }

    /**
     * @return
     */
    public int size() {
        return commands.size();
    }

}