/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/09 23:41:29
 */
package org.asyrinx.joey.gen.model.java;

import java.util.List;

import org.apache.commons.lang.enum.Enum;

/**
 * @author takeshi
 */
public class PackageType extends Enum {

    /**
     * @param name
     */
    public PackageType(String name) {
        super(name);
    }

    public static final PackageType ENTITY = new PackageType("entity");

    public static final PackageType DAO = new PackageType("dao");

    public static final PackageType DAO_HIBERNATE = new PackageType("dao.hibernate");

    public static final PackageType DAO_TEST = new PackageType("dao.test");
    
    public static final PackageType VIEW_SWING = new PackageType("swing");

    public static final PackageType VIEW_TAPESTRY = new PackageType("tapestry");

    public static List getElements() {
        return Enum.getEnumList(PackageType.class);
    }
}
