/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/09 15:56:27
 */
package org.asyrinx.joey.gen.model.java.classes;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author takeshi
 */
public class EmbeddedClassUtils {

    private static boolean classLoaded = false;

    private static void loadClasses() {
        if (classLoaded)
            return;
        classLoaded = true;
        final Log log = LogFactory.getLog(EmbeddedClass.class);
        log.info("loading embedded Classes....");
        log.info(JavaLangClass.STRING.getName());
        log.info(JavaUtilClass.DATE.getName());
        log.info(PrimitiveType.BOOLEAN.getName());
        log.info(PrimitiveWrapper.BOOLEAN.getName());
    }

    public static EmbeddedClass get(String name) {
        loadClasses();
        return EmbeddedClass.get(name);
    }

}