/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/10 16:58:33
 */
package org.asyrinx.joey.gen.model.rdb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.asyrinx.brownie.core.lang.NumberUtils;
import org.asyrinx.joey.gen.jdbc.JdbcUtils;
import org.asyrinx.joey.gen.model.Element;

/**
 * @author akima
 */
public class Column extends Element {

    /**
     */
    public Column() {
        this(null, null, null);
    }

    /**
     * @param table
     * @param name
     * @param type
     */
    public Column(Table parent, String name, String type) {
        super(parent, name);
        this.type = type;
    }

    /**
     * @param table
     * @param name
     * @param type
     * @param size
     */
    public Column(Table parent, String name, String type, String size) {
        this(parent, name, type, size, false, false);
    }

    /**
     * @param table
     * @param name
     * @param type
     * @param size
     * @param required
     */
    public Column(Table parent, String name, String type, String size, boolean required) {
        this(parent, name, type, size, required, false, null);
    }

    /**
     * @param table
     * @param name
     * @param type
     * @param size
     * @param required
     * @param primaryKey
     */
    public Column(Table parent, String name, String type, String size, boolean required, boolean primaryKey) {
        this(parent, name, type, size, required, primaryKey, null);
    }

    /**
     * @param table
     * @param name
     * @param type
     * @param size
     * @param required
     * @param primaryKey
     * @param defaultValue
     */
    public Column(Table parent, String name, String type, String size, boolean required, boolean primaryKey,
            String defaultValue) {
        super(parent, name);
        this.type = type;
        this.size = size;
        this.required = required;
        this.primaryKey = primaryKey;
        this.defaultValue = defaultValue;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.Element#getParentElement()
     */
    public Table getParent() {
        return (Table) super.getParentElement();
    }

    private String type = null;

    private String size = null;

    private String decimalSize = null;

    private boolean required = false;

    private boolean primaryKey = false;

    private String defaultValue = null;

    private String enum = null;

    private boolean autoIncrement = false;

    private String idMethod = null;

    private String fk = null;

    private String indexed = null;

    private boolean extended = false;

    /**
     * @return Returns the defaultValue.
     */
    public String getDefault() {
        return getDefaultValue();
    }

    public int getSizeAsInt() {
        return NumberUtils.toInt(getSize(), 0);
    }

    public int getDeciamlSizeAsInt() {
        return NumberUtils.toInt(getDecimalSize(), 0);
    }

    /**
     * @param defaultValue
     *            The defaultValue to set.
     */
    public void setDefault(String defaultValue) {
        this.setDefaultValue(defaultValue);
    }

    /**
     * @return Returns the defaultValue.
     */
    public String getDefaultValue() {
        return defaultValue;
    }

    /**
     * @param defaultValue
     *            The defaultValue to set.
     */
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    /**
     * @return Returns the primaryKey.
     */
    public boolean isPrimaryKey() {
        return primaryKey;
    }

    /**
     * @param primaryKey
     *            The primaryKey to set.
     */
    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    /**
     * @return Returns the required.
     */
    public boolean isRequired() {
        return required;
    }

    /**
     * @param required
     *            The required to set.
     */
    public void setRequired(boolean required) {
        this.required = required;
    }

    /**
     * @return Returns the size.
     */
    public String getSize() {
        return size;
    }

    /**
     * @param size
     *            The size to set.
     */
    public void setSize(String size) {
        this.size = size;
    }

    /**
     * @return Returns the type.
     */
    public String getType() {
        return type;
    }

    /**
     * @param type
     *            The type to set.
     */
    public void setType(String type) {
        this.type = type;
    }

    public int getJdbcType() {
        return JdbcUtils.toJdbcType(this.getType());
    }

    /**
     * @return Returns the enum.
     */
    public String getEnum() {
        return enum;
    }

    /**
     * @param enum
     *            The enum to set.
     */
    public void setEnum(String enum) {
        this.enum = enum;
    }

    public RdbEnumeration getEnumeration() {
        final Table table = getParent();
        if (table == null)
            return null;
        final Database database = table.getParent();
        return database.getEnumerations().getEnumeration(getEnum());
    }

    /**
     * @return Returns the autoIncrement.
     */
    public boolean isAutoIncrement() {
        return autoIncrement;
    }

    /**
     * @param autoIncrement
     *            The autoIncrement to set.
     */
    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    /**
     * @return Returns the idMethod.
     */
    public String getIdMethod() {
        return idMethod;
    }

    /**
     * @param idMethod
     *            The idMethod to set.
     */
    public void setIdMethod(String idMethod) {
        this.idMethod = idMethod;
    }

    /**
     * @return Returns the fk.
     */
    public String getFk() {
        return fk;
    }

    /**
     * @param fk
     *            The fk to set.
     */
    public void setFk(String fk) {
        this.fk = fk;
    }

    /**
     * @return Returns the indexed.
     */
    public String getIndexed() {
        return indexed;
    }

    /**
     * @param indexed
     *            The indexed to set.
     */
    public void setIndexed(String indexed) {
        this.indexed = indexed;
    }

    /**
     * @return Returns the extended.
     */
    public boolean isExtended() {
        return extended;
    }

    /**
     * @param extended
     *            The extended to set.
     */
    public void setExtended(boolean extended) {
        this.extended = extended;
    }

    public List getForeignKeysContainsAsLocal() {
        final List result = new ArrayList();
        final Table table = this.getParent();
        if (table == null)
            return result;
        for (Iterator i = table.getForeignKeys().iterator(); i.hasNext();) {
            final ForeignKey fk = (ForeignKey) i.next();
            if (fk.containsAsLocal(this))
                result.add(fk);
        }
        return result;
    }

    public String getDecimalSize() {
        return decimalSize;
    }

    public void setDecimalSize(String decimalSize) {
        this.decimalSize = decimalSize;
    }
}