/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/16 2:10:45
 */
package org.asyrinx.joey.gen.model.rdb;

import java.sql.Types;

import org.apache.commons.lang.enum.Enum;
import org.apache.commons.lang.enum.ValuedEnum;

/**
 * @author akima
 */
public class ColumnType extends ValuedEnum {

    /**
     * @param name
     * @param value
     */
    public ColumnType(int value, String name) {
        this(value, name, false);
    }

    /**
     * @param name
     * @param value
     */
    public ColumnType(int value, String name, boolean requiredSize) {
        super(name, value);
        this.requiredSize = requiredSize;
    }

    private final boolean requiredSize;

    public int toJdbcType() {
        return getValue();
    }

    public boolean isRequiredSize() {
        return this.requiredSize;
    }

    public static ColumnType get(String name) {
        return (ColumnType) Enum.getEnum(ColumnType.class, name);
    }

    public static ColumnType get(int value) {
        return (ColumnType) ValuedEnum.getEnum(ColumnType.class, value);
    }

    public static ColumnType get(Number value) {
        return get(value.intValue());
    }

    public static final ColumnType BIT = new ColumnType(Types.BIT, "BIT");

    public static final ColumnType TINYINT = new ColumnType(Types.TINYINT, "TINYINT");

    public static final ColumnType SMALLINT = new ColumnType(Types.SMALLINT, "SMALLINT");

    public static final ColumnType INTEGER = new ColumnType(Types.INTEGER, "INTEGER");

    public static final ColumnType BIGINT = new ColumnType(Types.BIGINT, "BIGINT");

    public static final ColumnType FLOAT = new ColumnType(Types.FLOAT, "FLOAT");

    public static final ColumnType REAL = new ColumnType(Types.REAL, "REAL");

    public static final ColumnType DOUBLE = new ColumnType(Types.DOUBLE, "DOUBLE");

    public static final ColumnType NUMERIC = new ColumnType(Types.NUMERIC, "NUMERIC");

    public static final ColumnType DECIMAL = new ColumnType(Types.DECIMAL, "DECIMAL");

    public static final ColumnType CHAR = new ColumnType(Types.CHAR, "CHAR", true);

    public static final ColumnType VARCHAR = new ColumnType(Types.VARCHAR, "VARCHAR", true);

    public static final ColumnType LONGVARCHAR = new ColumnType(Types.LONGVARCHAR, "LONGVARCHAR");

    public static final ColumnType DATE = new ColumnType(Types.DATE, "DATE");

    public static final ColumnType TIME = new ColumnType(Types.TIME, "TIME");

    public static final ColumnType TIMESTAMP = new ColumnType(Types.TIMESTAMP, "TIMESTAMP");

    public static final ColumnType BINARY = new ColumnType(Types.BINARY, "BINARY");

    public static final ColumnType VARBINARY = new ColumnType(Types.VARBINARY, "VARBINARY");

    public static final ColumnType LONGVARBINARY = new ColumnType(Types.LONGVARBINARY, "LONGVARBINARY");

    public static final ColumnType NULL = new ColumnType(Types.NULL, "NULL");

    public static final ColumnType JAVA_OBJECT = new ColumnType(Types.JAVA_OBJECT, "JAVA_OBJECT");

    public static final ColumnType DISTINCT = new ColumnType(Types.DISTINCT, "DISTINCT");

    public static final ColumnType STRUCT = new ColumnType(Types.STRUCT, "STRUCT");

    public static final ColumnType ARRAY = new ColumnType(Types.ARRAY, "ARRAY");

    public static final ColumnType BLOB = new ColumnType(Types.BLOB, "BLOB");

    public static final ColumnType CLOB = new ColumnType(Types.CLOB, "CLOB");

    public static final ColumnType REF = new ColumnType(Types.REF, "REF");

    public static final ColumnType DATALINK = new ColumnType(Types.DATALINK, "DATALINK");

    public static final ColumnType BOOLEAN = new ColumnType(Types.BOOLEAN, "BOOLEAN");
    //    	public final static int BIT = -7;
    //    	public final static int TINYINT = -6;
    //    	public final static int SMALLINT = 5;
    //    	public final static int INTEGER = 4;
    //    	public final static int BIGINT = -5;
    //    	public final static int FLOAT = 6;
    //    	public final static int REAL = 7;
    //    	public final static int DOUBLE = 8;
    //    	public final static int NUMERIC = 2;
    //    	public final static int DECIMAL = 3;
    //    	public final static int CHAR = 1;
    //    	public final static int VARCHAR = 12;
    //    	public final static int LONGVARCHAR = -1;
    //    	public final static int DATE = 91;
    //    	public final static int TIME = 92;
    //    	public final static int TIMESTAMP = 93;
    //    	public final static int BINARY = -2;
    //    	public final static int VARBINARY = -3;
    //    	public final static int LONGVARBINARY = -4;
    //    	public final static int NULL = 0;
    //    	public final static int OTHER = 1111;
    //            public final static int JAVA_OBJECT = 2000;
    //            public final static int DISTINCT = 2001;
    //            public final static int STRUCT = 2002;
    //            public final static int ARRAY = 2003;
    //            public final static int BLOB = 2004;
    //            public final static int CLOB = 2005;
    //            public final static int REF = 2006;
    //        public final static int DATALINK = 70;
    //        public final static int BOOLEAN = 16;

}