/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/10 17:15:16
 */
package org.asyrinx.joey.gen.model.rdb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.joey.gen.model.ElementSet;

/**
 * @author akima
 */
public class ForeignKey extends ElementSet {

    /**
     *  
     */
    public ForeignKey() {
        this(null, null, null);
    }

    /**
     * @param parent
     * @param name
     */
    public ForeignKey(String foreignTable) {
        this(null, null, foreignTable);
    }

    /**
     * @param parent
     * @param name
     */
    public ForeignKey(String name, String foreignTable) {
        this(null, name, foreignTable);
    }

    /**
     * @param parent
     * @param name
     */
    public ForeignKey(Table parent, String foreignTable) {
        this(parent, null, foreignTable);
    }

    /**
     * @param parent
     * @param name
     */
    public ForeignKey(Table parent, String name, String foreignTable) {
        super(parent, name);
        this.foreign = foreignTable;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#isEntity()
     */
    public boolean isEntity() {
        return true;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#add(org.asyrinx.joey.gen.model.Element)
     */
    public void add(ForeignKeyEntry entry) {
        super.add(entry);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#contains(org.asyrinx.joey.gen.model.Element)
     */
    public boolean contains(ForeignKeyEntry entry) {
        return super.contains(entry);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#getElement(int)
     */
    public ForeignKeyEntry getEntry(int idx) {
        return (ForeignKeyEntry) super.getElement(idx);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#get(java.lang.String)
     */
    public ForeignKeyEntry getEntry(String name) {
        return (ForeignKeyEntry) super.getElement(name);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.ElementSet#remove(java.lang.String)
     */
    public ForeignKeyEntry removeEntry(String name) {
        return (ForeignKeyEntry) super.removeElement(name);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.model.Element#getParentElement()
     */
    public Table getParent() {
        return (Table) super.getParentElement();
    }

    public Table getLocal() {
        return getParent();
    }

    protected final Table getTable(String name) {
        final Table parent = getParent();
        if (parent == null)
            return null;
        final Database database = parent.getParent();
        if (database == null)
            return null;
        return database.getTables().getTable(name);
    }

    public Table getForeignTable() {
        return getTable(getForeign());
    }

    public String getLocalColumnNames() {
        final List list = new ArrayList();
        for (final Iterator i = this.iterator(); i.hasNext();) {
            final ForeignKeyEntry entry = (ForeignKeyEntry) i.next();
            list.add(entry.getLocalColumn().getName());
        }
        return StringUtils.join(list.iterator(), ",");
    }

    public String getForeignColumnNames() {
        final List list = new ArrayList();
        for (final Iterator i = this.iterator(); i.hasNext();) {
            final ForeignKeyEntry entry = (ForeignKeyEntry) i.next();
            list.add(entry.getForeignColumn().getName());
        }
        return StringUtils.join(list.iterator(), ",");
    }

    private String foreign = null;

    private boolean indexed = true;

    private Index index = null;

    private ForeignKeyType type = ForeignKeyType.NORMAL;

    /**
     * @return Returns the foreign.
     */
    public String getForeign() {
        return foreign;
    }

    /**
     * @param foreign
     *            The foreign to set.
     */
    public void setForeign(String foreignTabe) {
        this.foreign = foreignTabe;
    }

    /**
     * @return Returns the indexed.
     */
    public boolean isIndexed() {
        return indexed;
    }

    /**
     * @param indexed
     *            The indexed to set.
     */
    public void setIndexed(boolean indexed) {
        this.indexed = indexed;
    }

    /**
     * @return Returns the index.
     */
    public Index getIndex() {
        return index;
    }

    /**
     * @param index
     *            The index to set.
     */
    public void setIndex(Index index) {
        this.index = index;
    }

    /**
     * @return Returns the type.
     */
    public ForeignKeyType getType() {
        return type;
    }

    /**
     * @param type
     *            The type to set.
     */
    public void setType(ForeignKeyType type) {
        this.type = type;
    }

    /**
     * @param column
     * @return
     */
    public boolean containsAsLocal(Column column) {
        for (Iterator i = this.iterator(); i.hasNext();) {
            final ForeignKeyEntry entry = (ForeignKeyEntry) i.next();
            if (entry.getLocalColumn() == column)
                return true;
        }
        return false;
    }
}