/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/16 2:49:52
 */
package test.org.asyrinx.joey.gen.command.rdb;

import junit.framework.TestCase;

import org.asyrinx.joey.gen.command.rdb.CheckColumnType;
import org.asyrinx.joey.gen.model.command.ValidationError;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Table;
import org.asyrinx.joey.gen.model.rdb.visitor.RdbVisitorAdapter;
import org.asyrinx.joey.gen.model.rdb.visitor.RdbTopDownVisitor;

/**
 * @author akima
 */
public class CheckColumnTypeTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(CheckColumnTypeTest.class);
    }

    public void testNormal() {
        final Table table1 = new Table("table1");
        new Column(table1, "col1-1", "BIGINT");
        new Column(table1, "col1-2", "INTEGER");
        new Column(table1, "col1-3", "VARCHAR", "20");
        //
        try {
            new RdbVisitorAdapter(new RdbTopDownVisitor(new CheckColumnType())).visit(table1);
        } catch (Throwable e) {
            e.printStackTrace();
            fail();
        }
    }

    public void testUncapitalized() {
        final Table table1 = new Table("table1");
        final Column col1 = new Column(table1, "col1-1", "BIGINT");
        final Column col2 = new Column(table1, "col1-2", "int");
        final Column col3 = new Column(table1, "col1-3", "VARCHAR", "20");
        //
        try {
            new CheckColumnType().execute(table1);
            //table1.accept(new RdbVisitorAdapter(new RdbTopDownVisitor(new CheckColumnType())));
            fail();
        } catch (ValidationError e) {
            assertEquals(col2, e.getElement());
        } catch (Throwable e) {
            e.printStackTrace();
            fail();
        }
        //G[ôŒ(ł̓_Ȃ̂ōēxG[)
        col2.setType("integer");
        try {
            new CheckColumnType().execute(table1);
            fail();
        } catch (ValidationError e) {
            assertEquals(col2, e.getElement());
        } catch (Throwable e) {
            e.printStackTrace();
            fail();
        }
        //
        col2.setType("INTEGER");
        try {
            new CheckColumnType().execute(table1);
        } catch (Throwable e) {
            e.printStackTrace();
            fail();
        }

    }
}