/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/14 20:53:09
 */
package test.org.asyrinx.joey.gen.command.rdb2java.standard;

import java.util.List;

import junit.framework.TestCase;

import org.asyrinx.joey.gen.command.rdb2java.standard.BasicBuilder;
import org.asyrinx.joey.gen.model.EnumerationEntry;
import org.asyrinx.joey.gen.model.java.AppDomain;
import org.asyrinx.joey.gen.model.java.Entity;
import org.asyrinx.joey.gen.model.java.EntityKey;
import org.asyrinx.joey.gen.model.java.JavaEnumeration;
import org.asyrinx.joey.gen.model.java.Parameter;
import org.asyrinx.joey.gen.model.java.Property;
import org.asyrinx.joey.gen.model.java.Reference;
import org.asyrinx.joey.gen.model.java.classes.JavaLangClass;
import org.asyrinx.joey.gen.model.java.classes.PrimitiveType;
import org.asyrinx.joey.gen.model.java.classes.PrimitiveWrapper;
import org.asyrinx.joey.gen.model.rdb.Column;
import org.asyrinx.joey.gen.model.rdb.Database;
import org.asyrinx.joey.gen.model.rdb.Databases;
import org.asyrinx.joey.gen.model.rdb.RdbEnumeration;
import org.asyrinx.joey.gen.model.rdb.Table;

/**
 * @author akima
 */
public class BasicBuilderTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(BasicBuilderTest.class);
    }

    public void testExecute() {

        final Databases databases = new Databases();
        final Database db1 = new Database(databases, "db1");
        db1.getOptions().put("javaPackage", "org.asyrinx.joey.sample");
        //
        final RdbEnumeration e_party_type = new RdbEnumeration(db1, "PartyType");
        e_party_type.setValueType("Integer");
        e_party_type.setLabel("p[eB^");
        new EnumerationEntry(e_party_type, "1", "individual", "l");
        new EnumerationEntry(e_party_type, "2", "corporation", "@l");
        //
        final Table t_party = new Table(db1, "party", "p[eB");
        new Column(t_party, "party_id", "BIGINT", "0", true, true, "0");
        new Column(t_party, "name", "VARCHAR", "20", true, false, null);
        final Column col_party_type = new Column(t_party, "party_type", "PartyType", "0", true, false, "corporation");
        col_party_type.setEnum("PartyType");
        //
        final BasicBuilder builder = new BasicBuilder();
        final AppDomain domain = builder.execute(databases);
        //
        assertEquals(1, domain.getClasses().size());
        assertEquals(1, domain.getEnumerations().size());
        //
        final JavaEnumeration je_party_type = domain.getEnumerations().getEnumeration(0);
        assertEquals("PartyType", je_party_type.getName());
        assertEquals("p[eB^", je_party_type.getLabel());
        assertEquals(PrimitiveWrapper.INTEGER, je_party_type.getValueTypeObj());
        assertEquals(2, je_party_type.size());
        assertEquals("1", je_party_type.getEntry(0).getValue());
        assertEquals("individual", je_party_type.getEntry(0).getName());
        assertEquals("l", je_party_type.getEntry(0).getLabel());
        assertEquals("2", je_party_type.getEntry(1).getValue());
        assertEquals("corporation", je_party_type.getEntry(1).getName());
        assertEquals("@l", je_party_type.getEntry(1).getLabel());
        //
        final Entity c_party = domain.getClasses().getJavaType(0);
        assertEquals("Party", c_party.getName());
        assertEquals("org.asyrinx.joey.sample", c_party.getPackage());
        assertEquals("org.asyrinx.joey.sample.Party", c_party.getFqn());
        assertEquals("p[eB", c_party.getLabel());
        assertEquals(3, c_party.getProperties().size());
        final Property p_party_id = c_party.getProperties().getProperty(0);
        assertEquals("partyId", p_party_id.getName());
        assertEquals("long", p_party_id.getTypeName());
        assertEquals(PrimitiveType.LONG, p_party_id.getType());
        assertEquals(0, p_party_id.getMaxLength());
        assertEquals(true, p_party_id.isRequired());
        assertEquals("0", p_party_id.getDefaultValue());
        final Property p_name = c_party.getProperties().getProperty(1);
        assertEquals("name", p_name.getName());
        assertEquals("String", p_name.getTypeName());
        assertEquals(JavaLangClass.STRING, p_name.getType());
        assertEquals(20, p_name.getMaxLength());
        assertEquals(true, p_name.isRequired());
        assertEquals("null", p_name.getDefaultValue());
        final Property p_party_type = c_party.getProperties().getProperty(2);
        assertEquals("partyType", p_party_type.getName());
        assertEquals("PartyType", p_party_type.getTypeName());
        assertEquals(je_party_type, p_party_type.getType());
        assertEquals(0, p_party_type.getMaxLength());
        assertEquals(true, p_party_type.isRequired());
        assertEquals("corporation", p_party_type.getDefaultValue());
        //
        assertEquals("partyTypeEnum", p_party_type.getEnumPropertyName());
        assertEquals(je_party_type, p_party_type.getEnumType());
    }

    public void testKeys() {
        final Databases databases = new Databases();
        final Database db1 = new Database(databases, "db1");
        db1.getOptions().put("javaPackage", "org.asyrinx.joey.sample");
        //
        final Table t_party = new Table(db1, "party", "p[eB");
        new Column(t_party, "party_id", "BIGINT", "0", true, true, "0");
        new Column(t_party, "name", "VARCHAR", "20", true, false, null);
        //
        final Table t_role = new Table(db1, "role", "[");
        new Column(t_role, "role_id", "BIGINT", "0", true, true, "0");
        final Column colPartyId = new Column(t_role, "party_id", "BIGINT", "0", true, false, "0");
        colPartyId.setFk("party.party_id");
        //
        final Table t_user = new Table(db1, "system_user", "VXe[U");
        t_user.setExtends("role");
        new Column(t_user, "system_user_id", "BIGINT", "0", true, true, "0");
        new Column(t_user, "values", "VARCHAR", "20", true, false, null);
        //
        final BasicBuilder builder = new BasicBuilder();
        final AppDomain domain = builder.execute(databases);
        //
        assertEquals(1, t_role.getForeignKeys().size());
        //
        assertEquals(3, domain.getClasses().size());
        assertEquals(0, domain.getEnumerations().size());
        //
        final Entity c_party = domain.getClasses().getJavaType(0);
        assertEquals("Party", c_party.getName());
        assertEquals("org.asyrinx.joey.sample", c_party.getPackage());
        assertEquals("org.asyrinx.joey.sample.Party", c_party.getFqn());
        assertEquals("p[eB", c_party.getLabel());
        assertEquals(2, c_party.getProperties().size());
        final Property p_party_id = c_party.getProperties().getProperty(0);
        assertEquals("partyId", p_party_id.getName());
        assertEquals("long", p_party_id.getTypeName());
        assertEquals(PrimitiveType.LONG, p_party_id.getType());
        assertEquals(0, p_party_id.getMaxLength());
        assertEquals(true, p_party_id.isRequired());
        assertEquals("0", p_party_id.getDefaultValue());
        final Property p_name = c_party.getProperties().getProperty(1);
        assertEquals("name", p_name.getName());
        assertEquals("String", p_name.getTypeName());
        assertEquals(JavaLangClass.STRING, p_name.getType());
        assertEquals(20, p_name.getMaxLength());
        assertEquals(true, p_name.isRequired());
        assertEquals("null", p_name.getDefaultValue());
        final EntityKey pk_party = c_party.getPrimaryKey();
        assertEquals(1, pk_party.size());
        assertEquals(p_party_id, pk_party.getEntry(0).getProperty());

        //
        final Entity c_role = domain.getClasses().getJavaType(1);
        assertEquals("Role", c_role.getName());
        assertEquals("org.asyrinx.joey.sample", c_role.getPackage());
        assertEquals("org.asyrinx.joey.sample.Role", c_role.getFqn());
        assertEquals("[", c_role.getLabel());
        assertEquals(2, c_role.getProperties().size());
        final Property p_role_id = c_role.getProperties().getProperty(0);
        assertEquals("roleId", p_role_id.getName());
        assertEquals("long", p_role_id.getTypeName());
        assertEquals(PrimitiveType.LONG, p_role_id.getType());
        assertEquals(0, p_role_id.getMaxLength());
        assertEquals(true, p_role_id.isRequired());
        assertEquals("0", p_role_id.getDefaultValue());
        final Property p_role_party_id = c_role.getProperties().getProperty(1);
        assertEquals("partyId", p_role_party_id.getName());
        assertEquals("long", p_role_party_id.getTypeName());
        assertEquals(PrimitiveType.LONG, p_role_party_id.getType());
        assertEquals(0, p_role_party_id.getMaxLength());
        assertEquals(true, p_role_party_id.isRequired());
        assertEquals("0", p_role_party_id.getDefaultValue());
        //
        final List role_allProperties = c_role.getPropertiesAll();
        assertEquals(2, role_allProperties.size());
        assertEquals(p_role_id, role_allProperties.get(0));
        assertEquals(p_role_party_id, role_allProperties.get(1));
        //
        final Entity c_system_user = domain.getClasses().getJavaType(2);
        assertEquals("SystemUser", c_system_user.getName());
        assertEquals("org.asyrinx.joey.sample", c_system_user.getPackage());
        assertEquals("org.asyrinx.joey.sample.SystemUser", c_system_user.getFqn());
        assertEquals("VXe[U", c_system_user.getLabel());
        assertEquals(3, c_system_user.getProperties().size());
        assertEquals(c_role, c_system_user.getSuperClass());
        final Property p_system_user_id = c_system_user.getProperties().getProperty(0);
        assertEquals("systemUserId", p_system_user_id.getName());
        assertEquals("long", p_system_user_id.getTypeName());
        assertEquals(PrimitiveType.LONG, p_system_user_id.getType());
        assertEquals(0, p_system_user_id.getMaxLength());
        assertEquals(true, p_system_user_id.isRequired());
        assertEquals("0", p_system_user_id.getDefaultValue());
        final Property p_values = c_system_user.getProperties().getProperty(1);
        assertEquals("values", p_values.getName());
        assertEquals("String", p_values.getTypeName());
        assertEquals(JavaLangClass.STRING, p_values.getType());
        assertEquals(20, p_values.getMaxLength());
        assertEquals(true, p_values.isRequired());
        assertEquals("null", p_values.getDefaultValue());
        // ̃vpeB͌pɂ͂Ȃ̂ŁAȂBΉJ͐
        //final Property p_system_user_role_id =
        // c_system_user.getProperties().getProperty(2);
        //assertEquals("roleId", p_system_user_role_id.getName());
        //assertEquals("long", p_system_user_role_id.getType());
        //assertEquals(PrimitiveType.LONG,
        // p_system_user_role_id.getJavaType());
        //assertEquals(0, p_system_user_role_id.getMaxLength());
        //assertEquals(true, p_system_user_role_id.isRequired());
        //assertEquals("0", p_system_user_role_id.getDefaultValue());
        final List systemUser_allProperties = c_system_user.getPropertiesAll();
        assertEquals(5, systemUser_allProperties.size());
        assertEquals(p_role_id, systemUser_allProperties.get(0));
        assertEquals(p_role_party_id, systemUser_allProperties.get(1));
        assertEquals(p_system_user_id, systemUser_allProperties.get(2));
        assertEquals(p_values, systemUser_allProperties.get(3));

        //
        assertEquals(1, c_role.getReferences().size());
        final Reference ref_role_to_party = c_role.getReferences().getReference(0);
        assertEquals("Party", ref_role_to_party.getReferenceClassName());
        assertEquals(c_party, ref_role_to_party.getReferenceClass());
        assertEquals(p_role_party_id, ref_role_to_party.getEntry(0).getLocal());
        assertEquals(p_party_id, ref_role_to_party.getEntry(0).getForeign());
        assertEquals(1, p_role_party_id.getReferencesContainedAsLocal().size());
        assertEquals(0, p_role_party_id.getReferencesContainedAsForeign().size());
        assertEquals(0, p_party_id.getReferencesContainedAsLocal().size());
        assertEquals(1, p_party_id.getReferencesContainedAsForeign().size());
        //
        assertEquals("party", ref_role_to_party.getPropertyNameInLocal());
        assertEquals("roles", ref_role_to_party.getPropertyNameInReferred());
        assertEquals("role", ref_role_to_party.getPropertyNameInReferred(false));
        //
        assertEquals(1, c_party.getReferreds().size());
        assertEquals(ref_role_to_party, c_party.getReferreds().get(0));
        assertEquals(0, c_role.getReferreds().size());
    }

    public void testReference() {
        final Databases databases = new Databases();
        final Database db1 = new Database(databases, "db1");
        db1.getOptions().put("javaPackage", "org.asyrinx.joey.sample");
        //
        final Table t_party = new Table(db1, "party", "p[eB");
        new Column(t_party, "party_id", "BIGINT", "0", true, true, "0");
        new Column(t_party, "name", "VARCHAR", "20", true, false, null);
        //
        final Table t_relation = new Table(db1, "relation", "֌W");
        new Column(t_relation, "relation_id", "BIGINT", "0", true, true, "0");
        final Column colOriginPartyId = new Column(t_relation, "origin_party_id", "BIGINT", "0", true, false, "0");
        final Column colDestPartyId = new Column(t_relation, "dest_party_id", "BIGINT", "0", true, false, "0");
        colOriginPartyId.setFk("party.party_id");
        colDestPartyId.setFk("party.party_id");
        //
        final BasicBuilder builder = new BasicBuilder();
        final AppDomain domain = builder.execute(databases);
        //
        assertEquals(2, t_relation.getForeignKeys().size());
        //
        assertEquals(2, domain.getClasses().size());
        //
        final Entity c_party = domain.getClasses().getJavaType(0);
        assertEquals("Party", c_party.getName());
        assertEquals("org.asyrinx.joey.sample", c_party.getPackage());
        assertEquals("org.asyrinx.joey.sample.Party", c_party.getFqn());
        assertEquals("p[eB", c_party.getLabel());
        assertEquals(2, c_party.getProperties().size());
        final Property p_party_id = c_party.getProperties().getProperty(0);
        assertEquals("partyId", p_party_id.getName());
        assertEquals("long", p_party_id.getTypeName());
        assertEquals(PrimitiveType.LONG, p_party_id.getType());
        assertEquals(0, p_party_id.getMaxLength());
        assertEquals(true, p_party_id.isRequired());
        assertEquals("0", p_party_id.getDefaultValue());
        final Property p_name = c_party.getProperties().getProperty(1);
        assertEquals("name", p_name.getName());
        assertEquals("String", p_name.getTypeName());
        assertEquals(JavaLangClass.STRING, p_name.getType());
        assertEquals(20, p_name.getMaxLength());
        assertEquals(true, p_name.isRequired());
        assertEquals("null", p_name.getDefaultValue());
        final EntityKey pk_party = c_party.getPrimaryKey();
        assertEquals(1, pk_party.size());
        assertEquals(p_party_id, pk_party.getEntry(0).getProperty());
        //
        final Entity c_relation = domain.getClasses().getJavaType(1);
        assertEquals("Relation", c_relation.getName());
        assertEquals("org.asyrinx.joey.sample", c_relation.getPackage());
        assertEquals("org.asyrinx.joey.sample.Relation", c_relation.getFqn());
        assertEquals("֌W", c_relation.getLabel());
        assertEquals(3, c_relation.getProperties().size());
        final Property p_role_id = c_relation.getProperties().getProperty(0);
        assertEquals("relationId", p_role_id.getName());
        assertEquals("long", p_role_id.getTypeName());
        assertEquals(PrimitiveType.LONG, p_role_id.getType());
        assertEquals(0, p_role_id.getMaxLength());
        assertEquals(true, p_role_id.isRequired());
        assertEquals("0", p_role_id.getDefaultValue());
        final Property p_origin_party_id = c_relation.getProperties().getProperty(1);
        assertEquals("originPartyId", p_origin_party_id.getName());
        assertEquals("long", p_origin_party_id.getTypeName());
        assertEquals(PrimitiveType.LONG, p_origin_party_id.getType());
        assertEquals(0, p_origin_party_id.getMaxLength());
        assertEquals(true, p_origin_party_id.isRequired());
        assertEquals("0", p_origin_party_id.getDefaultValue());
        final Property p_dest_party_id = c_relation.getProperties().getProperty(2);
        assertEquals("destPartyId", p_dest_party_id.getName());
        assertEquals("long", p_dest_party_id.getTypeName());
        assertEquals(PrimitiveType.LONG, p_dest_party_id.getType());
        assertEquals(0, p_dest_party_id.getMaxLength());
        assertEquals(true, p_dest_party_id.isRequired());
        assertEquals("0", p_dest_party_id.getDefaultValue());
        //
        assertEquals(2, c_relation.getReferences().size());
        assertEquals(1, p_origin_party_id.getReferencesContainedAsLocal().size());
        assertEquals(0, p_origin_party_id.getReferencesContainedAsForeign().size());
        assertEquals(0, p_party_id.getReferencesContainedAsLocal().size());
        assertEquals(2, p_party_id.getReferencesContainedAsForeign().size());
        final Reference ref_origin_to_party = c_relation.getReferences().getReference(0);
        assertEquals("Party", ref_origin_to_party.getReferenceClassName());
        assertEquals(c_party, ref_origin_to_party.getReferenceClass());
        assertEquals(p_origin_party_id, ref_origin_to_party.getEntry(0).getLocal());
        assertEquals(p_party_id, ref_origin_to_party.getEntry(0).getForeign());
        assertEquals("partyRelatedByOriginPartyId", ref_origin_to_party.getPropertyNameInLocal());
        assertEquals("relationsRelatedByOriginPartyId", ref_origin_to_party.getPropertyNameInReferred());
        assertEquals("relationRelatedByOriginPartyId", ref_origin_to_party.getPropertyNameInReferred(false));
        //
        final Reference ref_dest_to_party = c_relation.getReferences().getReference(1);
        assertEquals("Party", ref_dest_to_party.getReferenceClassName());
        assertEquals(c_party, ref_dest_to_party.getReferenceClass());
        assertEquals(p_dest_party_id, ref_dest_to_party.getEntry(0).getLocal());
        assertEquals(p_party_id, ref_dest_to_party.getEntry(0).getForeign());
        assertEquals("partyRelatedByDestPartyId", ref_dest_to_party.getPropertyNameInLocal());
        assertEquals("relationsRelatedByDestPartyId", ref_dest_to_party.getPropertyNameInReferred());
        assertEquals("relationRelatedByDestPartyId", ref_dest_to_party.getPropertyNameInReferred(false));
        //
        assertEquals(2, c_party.getReferreds().size());
        assertEquals(ref_origin_to_party, c_party.getReferreds().get(0));
        assertEquals(ref_dest_to_party, c_party.getReferreds().get(1));
        assertEquals(0, c_relation.getReferreds().size());
    }

    public void testPackaging() {

        final Databases databases = new Databases();
        final Database db1 = new Database(databases, "db1");
        db1.getOptions().put("javaPackage", "org.asyrinx.joey.${packageType}.party");
        final Table t_party = new Table(db1, "party", "p[eB");
        new Column(t_party, "party_id", "BIGINT", "0", true, true, "0");
        //
        final Database db1_ = new Database(databases, "db1");
        db1_.getOptions().put("javaPackage", "org.asyrinx.joey.${packageType}.report");
        final Table t_report = new Table(db1_, "report", "");
        final Column col_reporter_id = new Column(t_report, "reporter_id", "BIGINT", "0", true, true, "0");
        col_reporter_id.setFk("party.party_id");
        final Table t_notify = new Table(db1_, "notify", "ʒm");
        //
        final BasicBuilder builder = new BasicBuilder();
        final AppDomain domain = builder.execute(databases);
        //
        assertEquals(1, databases.getDatabases().size());
        assertEquals(db1, databases.getDatabases().getDatabase(0));
        //
        assertEquals(3, domain.getClasses().size());
        final Entity ety_party = domain.getClasses().getJavaType(0);
        final Entity ety_report = domain.getClasses().getJavaType(1);
        final Entity ety_notify = domain.getClasses().getJavaType(2);
        assertEquals("Party", ety_party.getName());
        assertEquals("Report", ety_report.getName());
        assertEquals("Notify", ety_notify.getName());
        //
        assertEquals("org.asyrinx.joey.entity.party", ety_party.getPackageName());
        assertEquals("org.asyrinx.joey.entity.report", ety_report.getPackageName());
        assertEquals("org.asyrinx.joey.entity.report", ety_notify.getPackageName());
        //
        assertEquals("org.asyrinx.joey.dao.party", ety_party.getPackage("dao"));
        assertEquals("org.asyrinx.joey.dao.report", ety_report.getPackage("dao"));
        assertEquals("org.asyrinx.joey.dao.report", ety_notify.getPackage("dao"));
        //
        assertEquals(1, ety_party.getImports().size());
        assertEquals("org.asyrinx.joey.entity.report.Report", ety_party.getImports().iterator().next());
        assertEquals(1, ety_report.getImports().size());
        assertEquals("org.asyrinx.joey.entity.party.Party", ety_report.getImports().iterator().next());
    }

    public void testConstructorParams() {
        final Databases databases = new Databases();
        final Database db1 = new Database(databases, "db1");
        //
        final Table t_party = new Table(db1, "party", "p[eB");
        new Column(t_party, "party_id", "BIGINT", "0", true, true, "0");
        new Column(t_party, "name", "VARCHAR", "20", true, false, null);
        //
        final Table t_role = new Table(db1, "role", "[");
        new Column(t_role, "role_id", "BIGINT", "0", true, true, "0");
        final Column colPartyId = new Column(t_role, "party_id", "BIGINT", "0", true, false, "0");
        colPartyId.setFk("party.party_id");
        //
        final Table t_user = new Table(db1, "system_user", "VXe[U");
        t_user.setExtends("role");
        new Column(t_user, "values", "VARCHAR", "20", true, false, null);
        //
        final BasicBuilder builder = new BasicBuilder();
        final AppDomain domain = builder.execute(databases);
        //
        assertEquals(3, domain.getClasses().size());
        final Entity e_party = domain.getClasses().getJavaType("Party");
        final Entity e_role = domain.getClasses().getJavaType("Role");
        final Entity e_user = domain.getClasses().getJavaType("SystemUser");
        assertNotNull(e_party);
        assertNotNull(e_role);
        assertNotNull(e_user);
        {
            final List e_party_params = e_party.getConstructorParams();
            assertEquals(2, e_party_params.size());
            assertEquals(Property.class, e_party_params.get(0).getClass());
            assertEquals(Property.class, e_party_params.get(1).getClass());
            final Parameter e_party_params_id = (Parameter) e_party_params.get(0);
            assertEquals("partyId", e_party_params_id.getParamName());
            assertEquals("long", e_party_params_id.getParamType().getName());
            final Parameter e_party_params_name = (Parameter) e_party_params.get(1);
            assertEquals("name", e_party_params_name.getParamName());
            assertEquals("String", e_party_params_name.getParamType().getName());
        }
        {
            final List e_role_params = e_role.getConstructorParams();
            assertEquals(2, e_role_params.size());
            assertEquals(Property.class, e_role_params.get(0).getClass());
            assertEquals(Reference.class, e_role_params.get(1).getClass());
            final Parameter e_party_params_id = (Parameter) e_role_params.get(0);
            assertEquals("roleId", e_party_params_id.getParamName());
            assertEquals("long", e_party_params_id.getParamType().getName());
            final Parameter e_party_params_party = (Parameter) e_role_params.get(1);
            assertEquals("party", e_party_params_party.getParamName());
            assertEquals("Party", e_party_params_party.getParamType().getName());
        }
        {
            final List e_user_params = e_user.getConstructorParams();
            assertEquals(3, e_user_params.size());
            assertEquals(Property.class, e_user_params.get(0).getClass());
            assertEquals(Reference.class, e_user_params.get(1).getClass());
            assertEquals(Property.class, e_user_params.get(2).getClass());
            final Parameter e_party_params_id = (Parameter) e_user_params.get(0);
            assertEquals("roleId", e_party_params_id.getParamName());
            assertEquals("long", e_party_params_id.getParamType().getName());
            final Parameter e_party_params_party = (Parameter) e_user_params.get(1);
            assertEquals("party", e_party_params_party.getParamName());
            assertEquals("Party", e_party_params_party.getParamType().getName());
            final Parameter e_party_params_name = (Parameter) e_user_params.get(2);
            assertEquals("values", e_party_params_name.getParamName());
            assertEquals("String", e_party_params_name.getParamType().getName());
        }
    }

    
    public void testReferencePropertyName() {
        final Databases databases = new Databases();
        final Database db1 = new Database(databases, "db1");
        db1.getOptions().put("javaPackage", "org.asyrinx.joey.sample");
        //
        final Table t_party = new Table(db1, "party", "p[eB");
        new Column(t_party, "party_id", "BIGINT", "0", true, true, "0");
        new Column(t_party, "name", "VARCHAR", "20", true, false, null);
        //
        final Table t_relation_type = new Table(db1, "relation_type", "֌W^");
        new Column(t_relation_type, "relation_type_id", "BIGINT", "0", true, true, "0");
        new Column(t_relation_type, "name", "VARCHAR", "20", true, false, null);
        //
        final Table t_relation_type_structure = new Table(db1, "relation_type_structure", "֌W^\");
        new Column(t_relation_type_structure, "relation_type_structure_id", "BIGINT", "0", true, true, "0");
        final Column colOriginRtId = new Column(t_relation_type_structure, "origin_relation_type_id", "BIGINT", "0", true, false, "0");
        final Column colDestRtId = new Column(t_relation_type_structure, "dest_relation_type_id", "BIGINT", "0", true, false, "0");
        colOriginRtId.setFk("relation_type.relation_type_id");
        colDestRtId.setFk("relation_type.relation_type_id");
        //
        final Table t_relation = new Table(db1, "relation", "֌W");
        new Column(t_relation, "relation_id", "BIGINT", "0", true, true, "0");
        final Column colOriginPartyId = new Column(t_relation, "origin_party_id", "BIGINT", "0", true, false, "0");
        final Column colDestPartyId = new Column(t_relation, "dest_party_id", "BIGINT", "0", true, false, "0");
        final Column colRelationType = new Column(t_relation, "relation_type_id", "BIGINT", "0", true, false, "0");
        colOriginPartyId.setFk("party.party_id");
        colDestPartyId.setFk("party.party_id");
        colRelationType.setFk("relation_type.relation_type_id");
        //
        final BasicBuilder builder = new BasicBuilder();
        final AppDomain domain = builder.execute(databases);
        //
        assertEquals(4, domain.getClasses().size());
        //
        final Entity c_party = domain.getClasses().getJavaType("Party");
        final Entity c_relation_type = domain.getClasses().getJavaType("RelationType");
        final Entity c_relation_type_struc = domain.getClasses().getJavaType("RelationTypeStructure");
        final Entity c_relation = domain.getClasses().getJavaType("Relation");
        //
        final Property p_party_id = c_party.getProperties().getProperty("partyId");
        final Property p_relation_type_id = c_relation_type.getProperties().getProperty("relationTypeId");
        //
        final Property p_origin_rt_id = c_relation_type_struc.getProperties().getProperty("originRelationTypeId");
        final Property p_dest_rt_id = c_relation_type_struc.getProperties().getProperty("destRelationTypeId");
        //
        final Reference ref_origin_to_rt = c_relation_type_struc.getReferences().getReference(0);
        assertEquals("RelationType", ref_origin_to_rt.getReferenceClassName());
        assertEquals(c_relation_type, ref_origin_to_rt.getReferenceClass());
        assertEquals(p_origin_rt_id, ref_origin_to_rt.getEntry(0).getLocal());
        assertEquals(p_relation_type_id, ref_origin_to_rt.getEntry(0).getForeign());
        assertEquals("relationTypeRelatedByOriginRelationTypeId", ref_origin_to_rt.getPropertyNameInLocal());
        assertEquals("relationTypeStructuresRelatedByOriginRelationTypeId", ref_origin_to_rt.getPropertyNameInReferred());
        assertEquals("relationTypeStructureRelatedByOriginRelationTypeId", ref_origin_to_rt.getPropertyNameInReferred(false));
        //
        final Reference ref_dest_to_rt = c_relation_type_struc.getReferences().getReference(1);
        assertEquals("RelationType", ref_dest_to_rt.getReferenceClassName());
        assertEquals(c_relation_type, ref_dest_to_rt.getReferenceClass());
        assertEquals(p_dest_rt_id, ref_dest_to_rt.getEntry(0).getLocal());
        assertEquals(p_relation_type_id, ref_dest_to_rt.getEntry(0).getForeign());
        assertEquals("relationTypeRelatedByDestRelationTypeId", ref_dest_to_rt.getPropertyNameInLocal());
        assertEquals("relationTypeStructuresRelatedByDestRelationTypeId", ref_dest_to_rt.getPropertyNameInReferred());
        assertEquals("relationTypeStructureRelatedByDestRelationTypeId", ref_dest_to_rt.getPropertyNameInReferred(false));
        //
        final Property p_role_id = c_relation.getProperties().getProperty(0);
        final Property p_origin_party_id = c_relation.getProperties().getProperty(1);
        final Property p_dest_party_id = c_relation.getProperties().getProperty(2);
        final Property p_relation_type_id2 = c_relation.getProperties().getProperty(3);
        //
        final Reference ref_origin_to_party = c_relation.getReferences().getReference(0);
        assertEquals("Party", ref_origin_to_party.getReferenceClassName());
        assertEquals(c_party, ref_origin_to_party.getReferenceClass());
        assertEquals(p_origin_party_id, ref_origin_to_party.getEntry(0).getLocal());
        assertEquals(p_party_id, ref_origin_to_party.getEntry(0).getForeign());
        assertEquals("partyRelatedByOriginPartyId", ref_origin_to_party.getPropertyNameInLocal());
        assertEquals("relationsRelatedByOriginPartyId", ref_origin_to_party.getPropertyNameInReferred());
        assertEquals("relationRelatedByOriginPartyId", ref_origin_to_party.getPropertyNameInReferred(false));
        //
        final Reference ref_dest_to_party = c_relation.getReferences().getReference(1);
        assertEquals("Party", ref_dest_to_party.getReferenceClassName());
        assertEquals(c_party, ref_dest_to_party.getReferenceClass());
        assertEquals(p_dest_party_id, ref_dest_to_party.getEntry(0).getLocal());
        assertEquals(p_party_id, ref_dest_to_party.getEntry(0).getForeign());
        assertEquals("partyRelatedByDestPartyId", ref_dest_to_party.getPropertyNameInLocal());
        assertEquals("relationsRelatedByDestPartyId", ref_dest_to_party.getPropertyNameInReferred());
        assertEquals("relationRelatedByDestPartyId", ref_dest_to_party.getPropertyNameInReferred(false));
        //
        final Reference ref_relation_type = c_relation.getReferences().getReference(2);
        assertEquals("RelationType", ref_relation_type.getReferenceClassName());
        assertEquals(c_relation_type, ref_relation_type.getReferenceClass());
        assertEquals(p_relation_type_id2, ref_relation_type.getEntry(0).getLocal());
        assertEquals(p_relation_type_id, ref_relation_type.getEntry(0).getForeign());
        assertEquals("relationType", ref_relation_type.getPropertyNameInLocal());
        assertEquals("relations", ref_relation_type.getPropertyNameInReferred());
        assertEquals("relation", ref_relation_type.getPropertyNameInReferred(false));
        //
        assertEquals(2, c_party.getReferreds().size());
        assertEquals(ref_origin_to_party, c_party.getReferreds().get(0));
        assertEquals(ref_dest_to_party, c_party.getReferreds().get(1));
        assertEquals(0, c_relation.getReferreds().size());
    }
    
    
}