package org.asyrinx.joey.gen.sample1.dao.hibernate;

import java.io.Serializable;
import java.util.List;

import org.asyrinx.brownie.core.query.BasicSelectBuilder;
import org.asyrinx.brownie.core.query.Select;
import org.asyrinx.brownie.core.query.SelectBuilder;
import org.asyrinx.brownie.core.query.StatementType;
import org.asyrinx.brownie.core.query.exp.IExpression;
import org.seasar.hibernate.S2SessionFactory;

import org.asyrinx.joey.gen.sample1.dao.*;
import org.asyrinx.joey.gen.sample1.entity.*;


/** 
 *
 * [Tue Nov 30 21:03:20 JST 2004]
 */
public class ApplicationUserDaoImpl implements ApplicationUserDao {

	/**
	 * 
	 */
	public ApplicationUserDaoImpl(S2SessionFactory sessionFactory) {
		super();
		this.sessionFactory = sessionFactory;
	}

    protected final S2SessionFactory sessionFactory;

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.sample1.dao.ApplicationUserDao#delete(org.asyrinx.joey.gen.sample1.entity.ApplicationUser)
     */
    public void delete(ApplicationUser obj) {
        sessionFactory.getSession().delete(obj);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.sample1.dao.ApplicationUserDao#save(org.asyrinx.joey.gen.sample1.entity.ApplicationUser)
     */
    public void save(ApplicationUser obj) {
        sessionFactory.getSession().saveOrUpdate(obj);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.sample1.dao.ApplicationUserDao#load(java.io.Serializable)
     */
    public ApplicationUser load(Serializable key) {
        if (key == null)
            return null;
        return (ApplicationUser) sessionFactory.getSession().load(ApplicationUser.class, key);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.sample1.dao.ApplicationUserDao#select(org.asyrinx.brownie.core.query.exp.IExpression)
     */
    public List select(IExpression expression) {
        final Select select = new Select();
        select.getWhere().add(expression);
        final SelectBuilder builder = new BasicSelectBuilder(StatementType.HQL);
        return sessionFactory.getSession().find(builder.buildSelect(select));
    }

}
