package org.asyrinx.joey.gen.sample1.dao.hibernate;

import java.io.Serializable;
import java.util.List;

import org.asyrinx.brownie.core.query.BasicSelectBuilder;
import org.asyrinx.brownie.core.query.Select;
import org.asyrinx.brownie.core.query.SelectBuilder;
import org.asyrinx.brownie.core.query.StatementType;
import org.asyrinx.brownie.core.query.exp.IExpression;
import org.seasar.hibernate.S2SessionFactory;

import org.asyrinx.joey.gen.sample1.dao.*;
import org.asyrinx.joey.gen.sample1.entity.*;


/** 
 *
 * [Tue Nov 30 21:03:20 JST 2004]
 */
public class PartyDaoImpl implements PartyDao {

	/**
	 * 
	 */
	public PartyDaoImpl(S2SessionFactory sessionFactory) {
		super();
		this.sessionFactory = sessionFactory;
	}

    protected final S2SessionFactory sessionFactory;

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.sample1.dao.PartyDao#delete(org.asyrinx.joey.gen.sample1.entity.Party)
     */
    public void delete(Party obj) {
        sessionFactory.getSession().delete(obj);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.sample1.dao.PartyDao#save(org.asyrinx.joey.gen.sample1.entity.Party)
     */
    public void save(Party obj) {
        sessionFactory.getSession().saveOrUpdate(obj);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.sample1.dao.PartyDao#load(java.io.Serializable)
     */
    public Party load(Serializable key) {
        if (key == null)
            return null;
        return (Party) sessionFactory.getSession().load(Party.class, key);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.sample1.dao.PartyDao#select(org.asyrinx.brownie.core.query.exp.IExpression)
     */
    public List select(IExpression expression) {
        final Select select = new Select();
        select.getWhere().add(expression);
        final SelectBuilder builder = new BasicSelectBuilder(StatementType.HQL);
        return sessionFactory.getSession().find(builder.buildSelect(select));
    }

}
