/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.collection;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;

public interface MapFactory {
    public static final MapFactory HashMap = new MapFactory(){

        public Map createMap() {
            return new HashMap();
        }
    };
    public static final MapFactory Hashtable = new MapFactory(){

        public Map createMap() {
            return new Hashtable();
        }
    };
    public static final MapFactory TreeMap = new MapFactory(){

        public Map createMap() {
            return new TreeMap();
        }
    };

    public Map createMap();

    public static final class Syncronized
    implements MapFactory {
        private final MapFactory factory;

        public Syncronized(MapFactory factory) {
            this.factory = factory;
        }

        public Map createMap() {
            return Collections.synchronizedMap(this.factory.createMap());
        }
    }
}

