/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.collection.matrix;

import java.util.ArrayList;
import java.util.List;
import org.asyrinx.brownie.core.collection.matrix.ListMatrix;

public class ArrayListMatrix
implements ListMatrix {
    private ArrayList baseRows = new ArrayList();

    private List findByRow(int row) {
        if (row < this.baseRows.size()) {
            return (List)this.baseRows.get(row);
        }
        return null;
    }

    private List needByRow(int row) {
        while (row >= this.baseRows.size()) {
            this.baseRows.add(new ArrayList());
        }
        return (List)this.baseRows.get(row);
    }

    public Object get(int col, int row) {
        List source = this.findByRow(row);
        if (source == null) {
            return null;
        }
        if (col < source.size()) {
            return source.get(col);
        }
        return null;
    }

    public void put(int col, int row, Object value) {
        List dest = this.needByRow(row);
        while (col >= dest.size()) {
            dest.add(null);
        }
        dest.set(col, value);
    }

    public void remove(int col, int row) {
        List source = this.findByRow(row);
        if (source == null) {
            return;
        }
        source.remove(col);
    }

    public void clear() {
        this.baseRows.clear();
    }

    public int colSize() {
        int result = 0;
        int i = 0;
        while (i < this.baseRows.size()) {
            List row = (List)this.baseRows.get(i);
            if (result < row.size()) {
                result = row.size();
            }
            ++i;
        }
        return result;
    }

    public int rowSize() {
        return this.baseRows.size();
    }

    public List getCol(int colKey) {
        if (colKey < this.colSize()) {
            ArrayList<Object> result = new ArrayList<Object>();
            int rowCount = this.rowSize();
            int i = 0;
            while (i < rowCount) {
                result.add(this.get(colKey, i));
                ++i;
            }
            return result;
        }
        return null;
    }

    public List getRow(int rowKey) {
        List source = this.findByRow(rowKey);
        if (source != null) {
            ArrayList result = new ArrayList(source);
            int colCount = this.colSize();
            while (result.size() < colCount) {
                result.add(null);
            }
            return result;
        }
        return null;
    }
}

