/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.log;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DispatchLog
implements Log {
    public static final String LEVEL_FATAL = "fatal";
    public static final String LEVEL_ERROR = "error";
    public static final String LEVEL_WARN = "warn";
    public static final String LEVEL_INFO = "info";
    public static final String LEVEL_DEBUG = "debug";
    public static final String LEVEL_TRACE = "trace";
    public static final String DEFAULT_LEVEL = "debug";
    private Log log;
    private String defaultLevel;
    static /* synthetic */ Class class$0;

    public DispatchLog() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.asyrinx.brownie.core.log.DispatchLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this(LogFactory.getLog((Class)clazz), "debug");
    }

    public DispatchLog(Log log) {
        this(log, "debug");
    }

    public DispatchLog(Log log, String defaultLevel) {
        this.defaultLevel = "debug";
        this.log = log;
        this.setDefaultLevel(defaultLevel);
    }

    public void log(Object message, Throwable t) {
        this.log(this.defaultLevel, message, t);
    }

    public void log(Object message) {
        this.log(this.defaultLevel, message);
    }

    public void log(String level, Object message, Throwable t) {
        if (LEVEL_FATAL.equals(level)) {
            this.log.fatal(message, t);
        } else if (LEVEL_ERROR.equals(level)) {
            this.log.error(message, t);
        } else if (LEVEL_WARN.equals(level)) {
            this.log.warn(message, t);
        } else if (LEVEL_INFO.equals(level)) {
            this.log.info(message, t);
        } else if ("debug".equals(level)) {
            this.log.debug(message, t);
        } else if (LEVEL_TRACE.equals(level)) {
            this.log.trace(message, t);
        }
    }

    public void log(String level, Object message) {
        if (LEVEL_FATAL.equals(level)) {
            this.log.fatal(message);
        } else if (LEVEL_ERROR.equals(level)) {
            this.log.error(message);
        } else if (LEVEL_WARN.equals(level)) {
            this.log.warn(message);
        } else if (LEVEL_INFO.equals(level)) {
            this.log.info(message);
        } else if ("debug".equals(level)) {
            this.log.debug(message);
        } else if (LEVEL_TRACE.equals(level)) {
            this.log.trace(message);
        }
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public String getDefaultLevel() {
        return this.defaultLevel;
    }

    public void setDefaultLevel(String string) {
        this.defaultLevel = string;
    }

    public void debug(Object message) {
        this.log.debug(message);
    }

    public void debug(Object message, Throwable t) {
        this.log.debug(message, t);
    }

    public void error(Object message) {
        this.log.error(message);
    }

    public void error(Object message, Throwable t) {
        this.log.error(message, t);
    }

    public void fatal(Object message) {
        this.log.fatal(message);
    }

    public void fatal(Object message, Throwable t) {
        this.log.fatal(message, t);
    }

    public void info(Object message) {
        this.log.info(message);
    }

    public void info(Object message, Throwable t) {
        this.log.info(message, t);
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.log.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    public void trace(Object message) {
        this.log.trace(message);
    }

    public void trace(Object message, Throwable t) {
        this.log.trace(message, t);
    }

    public void warn(Object message) {
        this.log.warn(message);
    }

    public void warn(Object message, Throwable t) {
        this.log.warn(message, t);
    }
}

