/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.seasar.servlet;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.asyrinx.brownie.core.io.sf.StreamFactoryFacade;
import org.asyrinx.brownie.servlet.FileNameResolver;
import org.asyrinx.brownie.servlet.ServletContextRuntimeException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerTagHandlerRule;
import org.seasar.framework.util.SAXParserFactoryUtil;
import org.seasar.framework.xml.SaxHandler;
import org.seasar.framework.xml.SaxHandlerParser;
import org.seasar.framework.xml.TagHandlerRule;

public class S2ContainerLoader {
    public static final String SERVLET_CONTEXT_PARAM_INITFILE = "s2config";
    public static final String SERVLET_CONTEXT_ATTRIBUTE_CONTAINER;
    private final ServletContext context;
    private final FileNameResolver resolver;
    private static S2ContainerTagHandlerRule rule_;
    private S2Container container = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.asyrinx.brownie.seasar.servlet.S2ContainerLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SERVLET_CONTEXT_ATTRIBUTE_CONTAINER = String.valueOf(clazz.getName()) + ".container";
        rule_ = new S2ContainerTagHandlerRule();
    }

    public S2ContainerLoader(ServletContext context) {
        this.context = context;
        this.resolver = new FileNameResolver(this.context);
    }

    private SaxHandlerParser createSaxHandlerParser() {
        SAXParserFactory factory = SAXParserFactoryUtil.newInstance();
        factory.setValidating(true);
        SAXParser saxParser = SAXParserFactoryUtil.newSAXParser((SAXParserFactory)factory);
        SaxHandler handler = new SaxHandler((TagHandlerRule)rule_);
        handler.registerDtdPath("-//SEASAR//DTD S2Container//EN", "org/seasar/framework/container/factory/components.dtd");
        SaxHandlerParser parser = new SaxHandlerParser(handler, saxParser);
        return parser;
    }

    public S2Container createContainer() throws IOException {
        SaxHandlerParser parser = this.createSaxHandlerParser();
        String webContextRealPath = this.resolver.getContextRootPath();
        InputStream inputStream = StreamFactoryFacade.newFacade(webContextRealPath).newInput(this.context.getInitParameter(SERVLET_CONTEXT_PARAM_INITFILE));
        return (S2Container)parser.parse(inputStream);
    }

    public void initializeContainer() {
        try {
            this.container = this.createContainer();
            this.context.setAttribute(SERVLET_CONTEXT_ATTRIBUTE_CONTAINER, (Object)this.container);
        }
        catch (IOException e) {
            throw new ServletContextRuntimeException(e);
        }
    }

    public void finalizeContainer() {
        this.container.destroy();
    }

    public static S2Container getContainer(ServletContext context) {
        return (S2Container)context.getAttribute(SERVLET_CONTEXT_ATTRIBUTE_CONTAINER);
    }
}

