/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.swing.table;

import javax.swing.table.TableModel;
import org.asyrinx.brownie.swing.table.key.KeyColumn;
import org.asyrinx.brownie.swing.table.key.KeyColumnTableModel;
import org.asyrinx.brownie.swing.table.key.RowKeyComparator;
import org.asyrinx.brownie.swing.table.key.SortableRowKey;

final class SortableTableModelImpl
extends KeyColumnTableModel {
    public SortableTableModelImpl(TableModel tableModel) {
        this(tableModel, null);
    }

    public SortableTableModelImpl(TableModel tableModel, int[] keyColumns) {
        super(tableModel, keyColumns);
        if (keyColumns != null) {
            this.initKeyColumns(keyColumns);
            this.refreshKeys();
        }
        this.initEventListener();
    }

    public void refreshKeys() {
        this.clearKeyList();
        int r = 0;
        while (r < this.tableModel.getRowCount()) {
            Object[] values = new Object[this.getKeyColumnCount()];
            int i = 0;
            while (i < this.getKeyColumnCount()) {
                KeyColumn keyColumn = this.getKeyColumn(i);
                values[i] = this.tableModel.getValueAt(r, keyColumn.getOriginalColumnIndex());
                ++i;
            }
            this.addRowKey(new SortableRowKey(values, r));
            ++r;
        }
        this.sortKeyList(new RowKeyComparator());
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        SortableRowKey rowKey = (SortableRowKey)this.getKey(rowIndex);
        return this.tableModel.getValueAt(rowKey.getOriginalRowIndex(), columnIndex);
    }
}

