/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.swing.table;

import javax.swing.table.TableModel;
import org.asyrinx.brownie.swing.table.ArrayAccessibleTableModelImpl;
import org.asyrinx.brownie.swing.table.InvisibleColumnTableModelImpl;
import org.asyrinx.brownie.swing.table.ListAccessibleTableModelImpl;
import org.asyrinx.brownie.swing.table.NullInvisibleColumnTableModel;
import org.asyrinx.brownie.swing.table.SimpleSortableTableModelImpl;
import org.asyrinx.brownie.swing.table.SortableTableModelImpl;
import org.asyrinx.brownie.swing.table.UneditableTableModel;
import org.asyrinx.brownie.swing.table.calc.CalcTableModel;
import org.asyrinx.brownie.swing.table.calc.CalcTableModelImpl;
import org.asyrinx.brownie.swing.table.util.ArrayAccessibleTableModel;
import org.asyrinx.brownie.swing.table.util.InvisibleColumnTableModel;
import org.asyrinx.brownie.swing.table.util.ListAccessibleTableModel;
import org.asyrinx.brownie.swing.table.util.SimpleSortableTableModel;

public class TableUtils {
    public static TableModel toUneditableModel(TableModel model) {
        return new UneditableTableModel(model);
    }

    public static InvisibleColumnTableModel toInvisibleColumnModel(TableModel model, int invisibleColumnIndex, int invisibleColumnCount) {
        if (invisibleColumnCount < 1) {
            return TableUtils.getNullModel(model);
        }
        if (invisibleColumnIndex < 0) {
            return TableUtils.getNullModel(model);
        }
        return new InvisibleColumnTableModelImpl(model, invisibleColumnIndex, invisibleColumnCount);
    }

    public static InvisibleColumnTableModel getNullModel(TableModel model) {
        return new NullInvisibleColumnTableModel(model);
    }

    public static SimpleSortableTableModel toSortableModel(TableModel model) {
        return new SimpleSortableTableModelImpl(model);
    }

    public static CalcTableModel toCalculatable(TableModel model, int[] keyColumns) {
        return new CalcTableModelImpl(model, keyColumns);
    }

    public static ListAccessibleTableModel toListAccessible(TableModel tableModel) {
        return new ListAccessibleTableModelImpl(tableModel);
    }

    public static ArrayAccessibleTableModel toArrayAccessible(TableModel tableModel) {
        return new ArrayAccessibleTableModelImpl(tableModel);
    }

    public static TableModel toSortable(TableModel model, int[] keyColumns) {
        return new SortableTableModelImpl(model, keyColumns);
    }
}

