/*
 * joey-gen and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/10 9:43:18
 */
package org.asyrinx.joey.gen.command.rdb;

import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.asyrinx.joey.gen.command.rdb2java.standard.JavaOptions;
import org.asyrinx.joey.gen.model.Element;
import org.asyrinx.joey.gen.model.rdb.RdbEnumeration;
import org.asyrinx.joey.gen.model.rdb.Table;

/**
 * @author takeshi
 */
public class CopyPackageNames extends RdbCommand {

    /**
     *  
     */
    public CopyPackageNames() {
        super();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.command.rdb.RdbCommand#visit(org.asyrinx.joey.gen.model.rdb.Table)
     */
    public void visit(Table table) {
        table.getOptions().put(JavaOptions.JAVA_PACKAGE, toPackageName(table));
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.command.rdb.RdbCommand#visit(org.asyrinx.joey.gen.model.rdb.RdbEnumeration)
     */
    public void visit(RdbEnumeration enumeration) {
        enumeration.getOptions().put(JavaOptions.JAVA_PACKAGE, toPackageName(enumeration));
    }

    public String getPackage(Map options) {
        final Object result = options.get(JavaOptions.JAVA_PACKAGE);
        return (result != null) ? result.toString() : null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.command.rdb2java.standard.PackagingStrategy#toPackageName(org.apache.commons.lang.enum.Enum)
     */
    public String toPackageName(RdbEnumeration enum) {
        final String result = toPackageNameImpl(enum);
        if (result != null)
            return result;
        else
            return (enum.getParent() == null) ? null : enum.getParent().getName();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.joey.gen.command.rdb2java.standard.PackagingStrategy#toPackageName(org.asyrinx.joey.gen.model.rdb.Table)
     */
    public String toPackageName(Table table) {
        final String result = toPackageNameImpl(table);
        if (result != null)
            return result;
        else
            return (table.getParent() == null) ? null : table.getParent().getName();
    }

    protected String toPackageNameImpl(Element element) {
        String result = getPackage(element.getOptions());
        if (!StringUtils.isEmpty(result)) {
            return result;
        } else {
            if (element.getParentElement() != null)
                return toPackageNameImpl(element.getParentElement());
            else
                return null;
        }
    }
}